/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Locale;
import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.security.CryptoAlgorithm;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.HashAlgorithm;
import org.gcube.io.jsonwebtoken.security.Request;
import org.gcube.io.jsonwebtoken.security.VerifyDigestRequest;

public final class DefaultHashAlgorithm
extends CryptoAlgorithm
implements HashAlgorithm {
    public static final HashAlgorithm SHA1 = new DefaultHashAlgorithm("sha-1");

    DefaultHashAlgorithm(String id) {
        super(id, id.toUpperCase(Locale.ENGLISH));
    }

    public byte[] digest(Request<InputStream> request) {
        Assert.notNull(request, (String)"Request cannot be null.");
        final InputStream payload = (InputStream)Assert.notNull((Object)request.getPayload(), (String)"Request payload cannot be null.");
        return this.jca(request).withMessageDigest(new CheckedFunction<MessageDigest, byte[]>(){

            @Override
            public byte[] apply(MessageDigest md) throws IOException {
                byte[] buf = new byte[1024];
                int len = 0;
                while (len != -1) {
                    len = payload.read(buf);
                    if (len <= 0) continue;
                    md.update(buf, 0, len);
                }
                return md.digest();
            }
        });
    }

    public boolean verify(VerifyDigestRequest request) {
        Assert.notNull((Object)request, (String)"VerifyDigestRequest cannot be null.");
        byte[] digest = (byte[])Assert.notNull((Object)request.getDigest(), (String)"Digest cannot be null.");
        byte[] computed = this.digest((Request<InputStream>)request);
        return MessageDigest.isEqual(computed, digest);
    }
}

