/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.retrieval;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.meta.features.FeaturesManager;
import org.gcube.dataanalysis.geo.utils.EnvDataExplorer;
import org.gcube.dataanalysis.geo.utils.FeaturedPolygon;
import org.gcube.dataanalysis.geo.utils.ThreddsDataExplorer;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.identification.Identification;

public class GeoIntersector {
    private FeaturesManager featurer = new FeaturesManager();
    private String configDir;

    public GeoIntersector(String scope, String cfgDir) {
        this.featurer.setScope(scope);
        this.configDir = cfgDir;
    }

    public FeaturesManager getFeaturer() {
        return this.featurer;
    }

    public LinkedHashMap<String, Double> getFeaturesInTime(String layerTitle, double x, double y) throws Exception {
        return this.getFeaturesInAllTimes(layerTitle, x, y, 0.0);
    }

    public LinkedHashMap<String, Double> getFeaturesInAllTimes(String layerTitle, double x, double y, double z) throws Exception {
        LinkedHashMap<String, Double> features = new LinkedHashMap<String, Double>();
        Metadata meta = this.featurer.getGNInfobyUUIDorName(layerTitle);
        if (meta != null) {
            String layer = this.featurer.getLayerName(meta);
            if (layer == null) {
                layer = layerTitle;
            }
            if (this.featurer.isThreddsFile(meta)) {
                Identification id = (Identification)meta.getIdentificationInfo().iterator().next();
                String title = id.getCitation().getTitle().toString();
                AnalysisLogger.getLogger().debug((Object)("found a netCDF file with title " + title + " and layer name " + layer));
                features = this.getFeaturesFromNetCDF(this.featurer.getOpenDapLink(meta), layer, x, y, z);
            } else {
                AnalysisLogger.getLogger().debug((Object)("found a Geo Layer with title " + layerTitle + " and layer name " + layer));
                features = this.getFeaturesFromWFS(this.featurer.getWFSLink(meta), layer, x, y);
            }
        }
        return features;
    }

    public List<Double> getFeaturesInTimeInstant(String layerTitle, int time, List<Tuple<Double>> triplets, double xL, double xR, double yL, double yR) throws Exception {
        List<Double> features = new ArrayList<Double>();
        Metadata meta = this.featurer.getGNInfobyUUIDorName(layerTitle);
        if (meta != null) {
            String layer = this.featurer.getLayerName(meta);
            if (layer == null) {
                layer = layerTitle;
            }
            if (this.featurer.isThreddsFile(meta)) {
                Identification id = (Identification)meta.getIdentificationInfo().iterator().next();
                String title = id.getCitation().getTitle().toString();
                AnalysisLogger.getLogger().debug((Object)("found a netCDF file with title " + title + " and layer name " + layer));
                features = this.getFeaturesFromNetCDF(this.featurer.getOpenDapLink(meta), layer, time, triplets, xL, xR, yL, yR);
            } else {
                AnalysisLogger.getLogger().debug((Object)("found a Geo Layer with reference " + layerTitle + " and layer name " + layer));
                List<Object> featuresInTime = new ArrayList();
                AnalysisLogger.getLogger().debug((Object)"taking WFS features");
                featuresInTime = this.getFeaturesFromWFS(this.featurer.getGeoserverLink(meta), layer, xL, yL, xR, yR);
                int tsize = triplets.size();
                AnalysisLogger.getLogger().debug((Object)("Intersecting " + tsize + " vs " + featuresInTime.size() + " elements"));
                int ttc = 0;
                Double[] featuresarray = new Double[tsize];
                int k = 0;
                long t0 = 0L;
                GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 4326);
                for (Tuple<Double> triplet : triplets) {
                    ArrayList elements = triplet.getElements();
                    CoordinateArraySequence pcoords = new CoordinateArraySequence(new Coordinate[]{new Coordinate(((Double)elements.get(0)).doubleValue(), ((Double)elements.get(1)).doubleValue())});
                    Point po = new Point((CoordinateSequence)pcoords, factory);
                    boolean found = false;
                    for (FeaturedPolygon featuredPolygon : featuresInTime) {
                        if (featuredPolygon == null || featuredPolygon.p == null || !featuredPolygon.p.covers((Geometry)po)) continue;
                        featuresarray[k] = featuredPolygon.value;
                        found = true;
                        break;
                    }
                    po = null;
                    if (!found) {
                        featuresarray[k] = Double.NaN;
                    }
                    if (ttc % 10000 == 0) {
                        AnalysisLogger.getLogger().debug((Object)("Status: " + (double)ttc * 100.0 / (double)tsize));
                    }
                    ++ttc;
                    ++k;
                }
                features = Arrays.asList(featuresarray);
            }
        }
        return features;
    }

    private List<Double> getFeaturesFromNetCDF(String opendapURL, String layer, int time, List<Tuple<Double>> triplets, double xL, double xR, double yL, double yR) {
        if (opendapURL == null) {
            return null;
        }
        return ThreddsDataExplorer.retrieveDataFromNetCDF(opendapURL, layer, time, triplets, xL, xR, yL, yR);
    }

    private LinkedHashMap<String, Double> getFeaturesFromNetCDF(String opendapURL, String layer, double x, double y, double z) {
        if (opendapURL == null) {
            return null;
        }
        return ThreddsDataExplorer.retrieveDataFromNetCDF(opendapURL, layer, x, y, z);
    }

    private LinkedHashMap<String, Double> getFeaturesFromWFS(String geoserverUrl, String layer, double x, double y) {
        if (geoserverUrl == null) {
            return null;
        }
        return EnvDataExplorer.getFeatures(geoserverUrl, layer, x, y);
    }

    private List<FeaturedPolygon> getFeaturesFromWFS(String geoserverUrl, String layer, double xL, double yL, double xR, double yR) {
        if (geoserverUrl == null) {
            return null;
        }
        return EnvDataExplorer.getFeatures(geoserverUrl, layer, xL, yL, xR, yR);
    }

    public static List<Tuple<Double>> generateCoordinateTriplets(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution) {
        int ysteps = (int)((y2 - y1) / yResolution);
        int xsteps = (int)((x2 - x1) / xResolution);
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        AnalysisLogger.getLogger().debug((Object)("Building the points grid according to YRes:" + yResolution + " and XRes:" + xResolution));
        int i = 0;
        while (i < ysteps + 1) {
            double y = (double)i * yResolution + y1;
            if (i == ysteps) {
                y = y2;
            }
            int j = 0;
            while (j < xsteps + 1) {
                double x = (double)j * xResolution + x1;
                if (j == xsteps) {
                    x = x2;
                }
                tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y, z}));
                ++j;
            }
            ++i;
        }
        return tuples;
    }

    public static List<Double> associateValueToCoordinates(List<Tuple<Double>> coordinates, double[][] data) {
        ArrayList<Double> values = new ArrayList<Double>();
        int k = 0;
        int g = 0;
        int ntriplets = coordinates.size();
        int xsteps = data[0].length - 1;
        int t = 0;
        while (t < ntriplets) {
            values.add(data[k][g]);
            if (g == xsteps) {
                g = 0;
                ++k;
            } else {
                ++g;
            }
            ++t;
        }
        return values;
    }

    public double[][] takeTimeSlice(String layerTitle, int timeInstant, double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Bounding box: (" + x1 + "," + x2 + ";" + y1 + "," + y2 + ")"));
        boolean faolayer = false;
        if (layerTitle.toLowerCase().contains("fao aquatic species distribution map")) {
            AnalysisLogger.getLogger().debug((Object)"FAO DISTRIBUTION LAYER ... TO APPY PATCH!");
            faolayer = true;
        }
        if (x2 < x1 || y2 < y1) {
            AnalysisLogger.getLogger().debug((Object)"ERROR: BAD BOUNDING BOX!!!");
            return new double[0][0];
        }
        int ysteps = (int)((y2 - y1) / yResolution);
        int xsteps = (int)((x2 - x1) / xResolution);
        double[][] slice = new double[ysteps + 1][xsteps + 1];
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        AnalysisLogger.getLogger().debug((Object)("Building the points grid according to YRes:" + yResolution + " and XRes:" + xResolution));
        int i = 0;
        while (i < ysteps + 1) {
            double y = (double)i * yResolution + y1;
            if (i == ysteps) {
                y = y2;
            }
            int j = 0;
            while (j < xsteps + 1) {
                double x = (double)j * xResolution + x1;
                if (j == xsteps) {
                    x = x2;
                }
                tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y, z}));
                ++j;
            }
            ++i;
        }
        AnalysisLogger.getLogger().debug((Object)("Taking " + ysteps + " values per " + xsteps + "=" + ysteps * xsteps + "..."));
        List<Double> timeValues = this.getFeaturesInTimeInstant(layerTitle, timeInstant, tuples, x1, x2, y1, y2);
        AnalysisLogger.getLogger().debug((Object)("Taken " + timeValues.size() + " values"));
        int k = 0;
        int g = 0;
        int ntriplets = timeValues.size();
        int t = 0;
        while (t < ntriplets) {
            Double value = timeValues.get(t);
            if (faolayer && value > 1.0) {
                AnalysisLogger.getLogger().debug((Object)"APPLYING FAO PATCH!");
                slice[k][g] = 0.5;
            } else {
                slice[k][g] = value;
            }
            if (g == xsteps) {
                g = 0;
                ++k;
            } else {
                ++g;
            }
            ++t;
        }
        AnalysisLogger.getLogger().debug((Object)("Features map: " + slice.length + "," + slice[0].length));
        return slice;
    }
}

