/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.GaussianDistributionGraph;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.evaluation.DiscrepancyAnalysis;
import org.gcube.dataanalysis.ecoengine.interfaces.DataAnalysis;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.geo.insertion.RasterTable;
import org.gcube.dataanalysis.geo.meta.features.FeaturesManager;
import org.gcube.dataanalysis.geo.retrieval.GeoIntersector;
import org.hibernate.SessionFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.NormalDistributionFunction2D;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.opengis.metadata.Metadata;

public class MapsComparator
extends DataAnalysis {
    static String layer1 = "Layer_1";
    static String layer2 = "Layer_2";
    static String zString = "Z";
    static String t1 = "TimeIndex_1";
    static String t2 = "TimeIndex_2";
    static String valuesThr = "ValuesComparisonThreshold";
    float status = 0.0f;
    public List<StatisticalType> inputs = new ArrayList<StatisticalType>();
    public LinkedHashMap<String, String> outputParameters = new LinkedHashMap();

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization");
    }

    public String getDescription() {
        return "An algorithm for comparing two OGC/NetCDF maps in seamless way to the user";
    }

    public void compute() throws Exception {
        int time2;
        this.status = 0.0f;
        AnalysisLogger.setLogger((String)(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        long t0 = System.currentTimeMillis();
        String layerT1 = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)layer1);
        String layerT2 = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)layer2);
        String z$ = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)zString);
        String valuesthr$ = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)valuesThr);
        String time1$ = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)t1);
        String time2$ = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)t2);
        int time1 = time1$ != null && time1$.trim().length() > 0 ? Integer.parseInt(time1$) : 0;
        int n = time2 = time2$ != null && time2$.trim().length() > 0 ? Integer.parseInt(time2$) : 0;
        if (time1 < 0) {
            time1 = 0;
        }
        if (time2 < 0) {
            time2 = 0;
        }
        double valuesthreshold = 0.1;
        if (valuesthr$ != null && valuesthr$.trim().length() > 0) {
            try {
                valuesthreshold = Double.parseDouble(valuesthr$);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double z = 0.0;
        if (z$ != null && z$.trim().length() > 0) {
            try {
                z = Double.parseDouble(z$);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            try {
                String scope = ScopeProvider.instance.get();
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Using Scope: " + scope + " Z: " + z + " Values Threshold: " + valuesthreshold + " Layer1: " + layerT1 + " vs " + layerT2));
                GeoIntersector intersector = new GeoIntersector(scope, this.config.getConfigPath());
                AnalysisLogger.getLogger().debug((Object)"MapsComparator: GeoIntersector initialized");
                double x1 = -180.0;
                double x2 = 180.0;
                double y1 = -90.0;
                double y2 = 90.0;
                this.status = 10.0f;
                FeaturesManager fm = intersector.getFeaturer();
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Taking info for the layer: " + layerT1));
                Metadata meta1 = fm.getGNInfobyUUIDorName(layerT1);
                if (meta1 == null) {
                    throw new Exception("No Correspondence with Layer 1");
                }
                double resolution1 = 0.0;
                try {
                    resolution1 = FeaturesManager.getResolution(meta1);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"MapsComparator: Undefined resolution");
                }
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Resolution: " + resolution1));
                this.status = 15.0f;
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Taking info for the layer: " + layerT2));
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Trying with UUID..." + layerT2));
                Metadata meta2 = fm.getGNInfobyUUIDorName(layerT2);
                if (meta2 == null) {
                    throw new Exception("No Correspondence with Layer 2");
                }
                double resolution2 = 0.0;
                try {
                    resolution2 = FeaturesManager.getResolution(meta2);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"MapsComparator: Undefined resolution");
                }
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Resolution: " + resolution2));
                this.status = 20.0f;
                double resolution = Math.max(resolution1, resolution2);
                if (resolution == 0.0) {
                    resolution = 0.5;
                }
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Evaluation Resolution: " + resolution));
                AnalysisLogger.getLogger().debug((Object)"MapsComparator: ****Rasterizing map 1****");
                double[][] slice1 = intersector.takeTimeSlice(layerT1, time1, x1, x2, y1, y2, z, resolution, resolution);
                AnalysisLogger.getLogger().debug((Object)"MapsComparator: Dumping map 1");
                this.status = 30.0f;
                RasterTable raster1 = new RasterTable(x1, x2, y1, y2, z, resolution, resolution, slice1, this.config);
                raster1.dumpGeoTable();
                String rastertable1 = raster1.getTablename();
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Map 1 was dumped in table: " + rastertable1));
                this.status = 40.0f;
                AnalysisLogger.getLogger().debug((Object)"MapsComparator: ****Rasterizing map 2****");
                double[][] slice2 = intersector.takeTimeSlice(layerT2, time2, x1, x2, y1, y2, z, resolution, resolution);
                AnalysisLogger.getLogger().debug((Object)"MapsComparator: Dumping map 2");
                this.status = 50.0f;
                RasterTable raster2 = new RasterTable(x1, x2, y1, y2, z, resolution, resolution, slice2, this.config);
                raster2.dumpGeoTable();
                String rastertable2 = raster2.getTablename();
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Map 2 was dumped in table: " + rastertable2));
                this.status = 60.0f;
                this.config.setNumberOfResources(Integer.valueOf(1));
                this.config.setParam("FirstTable", rastertable1);
                this.config.setParam("SecondTable", rastertable2);
                this.config.setParam("FirstTableCsquareColumn", RasterTable.csquareColumn);
                this.config.setParam("SecondTableCsquareColumn", RasterTable.csquareColumn);
                this.config.setParam("FirstTableProbabilityColumn", RasterTable.probabilityColumn);
                this.config.setParam("SecondTableProbabilityColumn", RasterTable.probabilityColumn);
                this.config.setParam("ComparisonThreshold", "" + valuesthreshold);
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Analyzing discrepancy between maps: " + rastertable1 + " and " + rastertable2));
                DiscrepancyAnalysis da = new DiscrepancyAnalysis();
                da.setConfiguration(this.config);
                da.init(false);
                this.outputParameters = da.analyze();
                this.outputParameters.put("RESOLUTION", "" + MathFunctions.roundDecimal((double)resolution, (int)4));
                this.status = 80.0f;
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Output: " + this.outputParameters));
                this.connection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Deleting table " + rastertable1));
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)rastertable1), (SessionFactory)this.connection);
                this.status = 90.0f;
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Deleting table " + rastertable2));
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)rastertable2), (SessionFactory)this.connection);
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: Elapsed: Whole operation completed in " + (double)(System.currentTimeMillis() - t0) / 1000.0 + "s"));
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: ERROR!: " + e.getLocalizedMessage()));
                DatabaseUtils.closeDBConnection((SessionFactory)this.connection);
                this.status = 100.0f;
            }
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)this.connection);
            this.status = 100.0f;
        }
    }

    public List<StatisticalType> getInputParameters() {
        IOHelper.addStringInput(this.inputs, (String)layer1, (String)"First Layer Title or UUID: The title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer", (String)"");
        IOHelper.addStringInput(this.inputs, (String)layer2, (String)"Second Layer Title or UUID: The title or the UUID (preferred)  of a second layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer", (String)"");
        IOHelper.addIntegerInput(this.inputs, (String)zString, (String)"value of Z. Default is 0, that means comparison will be at surface level", (String)"0");
        IOHelper.addDoubleInput(this.inputs, (String)valuesThr, (String)"A comparison threshold for the values in the map. Null equals to 0.1", (String)"0.1");
        IOHelper.addIntegerInput(this.inputs, (String)t1, (String)"First Layer Time Index. The default is the first", (String)"0");
        IOHelper.addIntegerInput(this.inputs, (String)t2, (String)"Second Layer Time Index. The default is the first", (String)"0");
        IOHelper.addDoubleInput(this.inputs, (String)"KThreshold", (String)"Threshold for K-Statistic: over this threshold values will be considered 1 for agreement calculation. Default is 0.5", (String)"0.5");
        DatabaseType.addDefaultDBPars(this.inputs);
        return this.inputs;
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }

    protected Image generateGaussian(double mean, double variance) {
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        if (variance == 0.0) {
            variance = 0.01;
        }
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Adopting mean:" + mean + " and variance:" + variance));
        NormalDistributionFunction2D normaldistributionfunction2d = new NormalDistributionFunction2D(mean, variance);
        XYSeries xyseries = DatasetUtilities.sampleFunction2DToSeries((Function2D)normaldistributionfunction2d, (double)(mean - 2.0 * variance), (double)(mean + 2.0 * variance), (int)121, (Comparable)((Object)"Distribution of the Error"));
        xyseriescollection.addSeries(xyseries);
        JFreeChart chart = GaussianDistributionGraph.createStaticChart((Dataset)xyseriescollection, (double)mean, (double)variance);
        Image image = ImageTools.toImage((BufferedImage)chart.createBufferedImage(680, 420));
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Gaussian Distribution Produced");
        return image;
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Gaussian Distribution for the errors");
        HashMap<String, Image> producedImages = new HashMap<String, Image>();
        double mean = Double.parseDouble(this.outputParameters.get("MEAN"));
        double variance = Double.parseDouble(this.outputParameters.get("VARIANCE"));
        producedImages.put("Error Distribution", this.generateGaussian(mean, variance));
        PrimitiveType images = new PrimitiveType("Images", producedImages, PrimitiveTypes.IMAGES, "Distribution of the Error", "The distribution of the error along with variance");
        LinkedHashMap<String, PrimitiveType> map = new LinkedHashMap<String, PrimitiveType>();
        for (String key : this.outputParameters.keySet()) {
            String value = this.outputParameters.get(key);
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)value, PrimitiveTypes.STRING, key, key);
            map.put(key, val);
        }
        map.put("Images", images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    public float getStatus() {
        return this.status;
    }

    public LinkedHashMap<String, String> analyze() throws Exception {
        return null;
    }
}

