package org.gcube.data.transfer.plugins.sis;

import java.io.File;
import java.util.Map;

import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.UnsupportedStorageException;
import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.ExecutionReport.ExecutionReportFlag;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.plugin.AbstractPlugin;
import org.gcube.data.transfer.plugin.fails.PluginCleanupException;
import org.gcube.data.transfer.plugin.fails.PluginExecutionException;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.opengis.metadata.Metadata;

import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class SisPlugin extends AbstractPlugin {

	public SisPlugin(PluginInvocation invocation) {
		super(invocation);
	}

	@Override
	public void cleanup() throws PluginCleanupException {
		
	}

	@Override
	public ExecutionReport run() throws PluginExecutionException {
		try{
		log.debug("Checking parameters for {} ",invocation);
		Map<String,String> params=invocation.getParameters();
		String dataStorePath=params.get(SISPluginFactory.SOURCE_PARAMETER);
		String category=params.containsKey(SISPluginFactory.GEONETWORK_CATEGORY)?params.get(SISPluginFactory.GEONETWORK_CATEGORY):"Dataset";
		String stylesheet=params.containsKey(SISPluginFactory.GEONETWORK_STYLESHEET)?params.get(SISPluginFactory.GEONETWORK_STYLESHEET):"_none_";
		File dataStore=new File(dataStorePath);
		log.debug("Extracting meta from {} ",dataStore.getAbsolutePath());
		Metadata meta=getMetaFromFile(dataStore);
		// TODO Links from current thredds
		// TODO Info from infrastructure
		long id=publishMetadata(meta, category, stylesheet);
		return new ExecutionReport(invocation, "Published meta with id : "+id, ExecutionReportFlag.SUCCESS);
		
		}catch(DataStoreException e){
			log.error("Unable to parse source ",e);
			throw new PluginExecutionException("Unable to extract metadata.", e);
		}catch(Throwable t){
			log.error("Unexpected error while generating metadata.",t);
			throw new PluginExecutionException("Unexpected error while generating meta.",t);
		}
	}

	
	public static final Metadata getMetaFromFile(Object dataStore) throws UnsupportedStorageException, DataStoreException{
		return DataStores.open(dataStore).getMetadata();
	}
	
	
	public static final long publishMetadata(Metadata meta,String category, String stylesheet) throws Exception{
		GeoNetworkPublisher publisher=GeoNetwork.get();
		publisher.login(LoginLevel.DEFAULT);
		GNInsertConfiguration config=publisher.getCurrentUserConfiguration(category, stylesheet);
		config.setValidate(false);
		return publisher.insertMetadata(config, meta);
	}
}
