/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.oai.tmplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gcube.data.oai.tmplugin.Lifecycle;
import org.gcube.data.oai.tmplugin.OAIReader;
import org.gcube.data.oai.tmplugin.OAISource;
import org.gcube.data.oai.tmplugin.ProductionProvider;
import org.gcube.data.oai.tmplugin.RepositoryProvider;
import org.gcube.data.oai.tmplugin.repository.Repository;
import org.gcube.data.oai.tmplugin.repository.Set;
import org.gcube.data.oai.tmplugin.requests.Request;
import org.gcube.data.oai.tmplugin.requests.RequestBinder;
import org.gcube.data.oai.tmplugin.requests.WrapRepositoryRequest;
import org.gcube.data.oai.tmplugin.requests.WrapSetsRequest;
import org.gcube.data.tmf.api.SourceBinder;
import org.gcube.data.tmf.api.SourceLifecycle;
import org.gcube.data.tmf.api.SourceReader;
import org.gcube.data.tmf.api.exceptions.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class OAIBinder
implements SourceBinder {
    private static Logger log = LoggerFactory.getLogger(OAIBinder.class);
    private RepositoryProvider provider;

    public OAIBinder() {
        this(new ProductionProvider());
    }

    OAIBinder(RepositoryProvider p) {
        this.provider = p;
    }

    public List<? extends OAISource> bind(Element DOMRequest) throws InvalidRequestException, Exception {
        Request request = null;
        try {
            request = new RequestBinder().bind(DOMRequest, Request.class);
        }
        catch (Exception e) {
            throw new InvalidRequestException("malformed request", (Throwable)e);
        }
        if (request instanceof WrapRepositoryRequest) {
            return this.wrapRepository((WrapRepositoryRequest)request);
        }
        if (request instanceof WrapSetsRequest) {
            return this.wrapSets((WrapSetsRequest)request);
        }
        throw new InvalidRequestException("unknown request " + DOMRequest.getTagName());
    }

    List<OAISource> wrapSets(WrapSetsRequest request) throws Exception {
        log.info("request.getSets() " + request.getSets());
        Repository repository = this.provider.newRepository(request);
        ArrayList<OAISource> sources = new ArrayList<OAISource>();
        List<Set> sets = repository.getSetsWith(request.getSets());
        log.info("sets " + sets.toString());
        for (Set set : sets) {
            String sourceId = set.id();
            OAISource source = new OAISource(sourceId);
            source.setName(set.name());
            source.setDescription(set.description());
            OAIReader reader = new OAIReader(source, repository, Arrays.asList(set));
            source.setReader((SourceReader)reader);
            source.setLifecycle((SourceLifecycle)new Lifecycle(source));
            log.trace("created source " + source.id());
            sources.add(source);
        }
        return sources;
    }

    List<OAISource> wrapRepository(WrapRepositoryRequest request) throws Exception {
        Repository repository = this.provider.newRepository(request);
        List<Set> sets = repository.getSetsWith(request.getSets());
        OAISource source = new OAISource(request.getId());
        source.setName(request.getName() == null ? repository.name() : request.getName());
        source.setDescription(request.getDescription() == null ? repository.description() : request.getDescription());
        source.setReader((SourceReader)new OAIReader(source, repository, sets));
        source.setLifecycle((SourceLifecycle)new Lifecycle(source));
        log.trace("created source {}" + source.id());
        return Collections.singletonList(source);
    }
}

