package org.gcube.data.analysis.tabulardata.cube.metadata;

import java.util.Map;

import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.gcube.common.database.DatabaseProvider;
import org.gcube.common.database.DatabaseEndpointIdentifier;
import org.gcube.common.database.endpoint.DatabaseEndpoint;
import org.gcube.common.database.endpoint.DatabaseProperty;

import com.google.common.collect.Maps;

@Default
public class ISEntityManagerProvider implements Provider<EntityManager> {

	private DatabaseEndpointIdentifier metaDBEndpointId;

	private DatabaseProvider dbProvider;

	private EntityManager em;

	@Inject
	public ISEntityManagerProvider(@Named("Metadata-Admin") DatabaseEndpointIdentifier metaDBEndpointId, DatabaseProvider dbProvider) {
		this.metaDBEndpointId = metaDBEndpointId;
		this.dbProvider = dbProvider;
	}

	@Produces
	@Override
	public EntityManager get() {
		if (em==null) {
			DatabaseEndpoint dbDescriptor = dbProvider.get(metaDBEndpointId);

			//Retrieve driver from properties
			String driver = null;
			String eclipseLinkTargetDb= null;  
			for (DatabaseProperty p : dbDescriptor.getProperties()) {
				if (p.getKey().equals("driver")) driver = p.getValue();
				if (p.getKey().equals("eclipselink.target-database")) driver = p.getValue();
			}
			if (driver == null) throw new RuntimeException("Unable to find the right driver for the connection to the DB: " + dbDescriptor);
			
			Map<String,String> properties = Maps.newHashMap();
			properties.put("javax.persistence.jdbc.user", dbDescriptor.getCredentials().getUsername());
			properties.put("javax.persistence.jdbc.password", dbDescriptor.getCredentials().getUsername());
			properties.put("javax.persistence.jdbc.driver", driver);
			properties.put("javax.persistence.jdbc.url", dbDescriptor.getConnectionString());
			properties.put("eclipselink.target-database", eclipseLinkTargetDb);
			EntityManagerFactory emf = Persistence.createEntityManagerFactory("default",properties); 
			
			em = emf.createEntityManager();
			}
		return em;
		
	}
}
