/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.software.examples;

import java.io.File;
import java.util.List;
import org.gcube.common.software.analyser.Analyser;
import org.gcube.common.software.analyser.AnalyserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProcessorExample {
    private static final Logger logger = LoggerFactory.getLogger(SimpleProcessorExample.class);

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("Usage: java SimpleProcessorExample <config.json> [output-directory]");
            System.err.println("Example: java SimpleProcessorExample docs/examples/gcat-doc.json ./output");
            System.exit(1);
        }
        String configPath = args[0];
        String outputPath = args.length > 1 ? args[1] : "./output";
        try {
            File configFile = new File(configPath);
            if (!configFile.exists()) {
                throw new RuntimeException("Configuration file not found: " + configPath);
            }
            logger.info("Loading configuration from: {}", (Object)configFile.getAbsolutePath());
            Analyser analyser = AnalyserFactory.getAnalyser(configFile);
            File outputDirectory = new File(outputPath);
            if (!outputDirectory.exists()) {
                outputDirectory.mkdirs();
                logger.info("Created output directory: {}", (Object)outputDirectory.getAbsolutePath());
            }
            analyser.setOutputDirectory(outputDirectory);
            logger.info("Starting software artifact processing...");
            List<File> outputFiles = analyser.analyse();
            logger.info("Processing completed successfully!");
            logger.info("Generated {} output files:", (Object)outputFiles.size());
            for (File file : outputFiles) {
                logger.info("  - {} ({} bytes)", (Object)file.getName(), (Object)file.length());
            }
            logger.info("\nOutput directory contents:");
            File[] allFiles = outputDirectory.listFiles();
            if (allFiles != null) {
                for (File file : allFiles) {
                    logger.info("  - {} ({} bytes)", (Object)file.getName(), (Object)file.length());
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to process software artifacts", (Throwable)e);
            System.exit(1);
        }
    }
}

