/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.request;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.gcube.common.gxhttp.reference.GXHTTP;
import org.gcube.common.gxhttp.reference.GXHTTPRequestBuilder;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXHTTPStringRequest
implements GXHTTP<String, GXInboundResponse> {
    protected static final Logger logger = LoggerFactory.getLogger(GXHTTPStringRequest.class);
    GXHTTPRequestBuilder builder = new GXHTTPRequestBuilder();

    private GXHTTPStringRequest(String address) {
        this.builder.connection = new GXConnection(address);
    }

    public static GXHTTPStringRequest newRequest(String address) {
        return new GXHTTPStringRequest(address);
    }

    public GXHTTPStringRequest withBody(String body) {
        this.builder.connection.addBody(body);
        return this;
    }

    public GXInboundResponse put(String body) throws Exception {
        if (Objects.nonNull(body)) {
            this.builder.connection.addBody(body);
        }
        logger.trace("Sending a PUT request...");
        return new GXInboundResponse(this.builder.connection.send(GXConnection.HTTPMETHOD.PUT));
    }

    public GXInboundResponse post(String body) throws Exception {
        logger.trace("Sending a POST request...");
        if (Objects.nonNull(body)) {
            this.builder.connection.addBody(body);
        }
        return new GXInboundResponse(this.builder.connection.send(GXConnection.HTTPMETHOD.POST));
    }

    public GXInboundResponse put() throws Exception {
        return new GXInboundResponse(this.builder.put());
    }

    public GXInboundResponse delete() throws Exception {
        return new GXInboundResponse(this.builder.delete());
    }

    public GXInboundResponse head() throws Exception {
        return new GXInboundResponse(this.builder.head());
    }

    public GXInboundResponse get() throws Exception {
        return new GXInboundResponse(this.builder.get());
    }

    public GXInboundResponse post() throws Exception {
        return new GXInboundResponse(this.builder.post());
    }

    public GXInboundResponse trace() throws Exception {
        return new GXInboundResponse(this.builder.trace());
    }

    public GXInboundResponse patch() throws Exception {
        return new GXInboundResponse(this.builder.patch());
    }

    public GXInboundResponse options() throws Exception {
        return new GXInboundResponse(this.builder.options());
    }

    public GXInboundResponse connect() throws Exception {
        return new GXInboundResponse(this.builder.connect());
    }

    public void setSecurityToken(String token) {
        this.builder.setSecurityToken(token);
    }

    public void isExternalCall(boolean ext) {
        this.builder.isExternalCall(ext);
    }

    public GXHTTPStringRequest from(String agent) {
        this.builder.from(agent);
        return this;
    }

    public void clear() {
        this.builder.clear();
    }

    public GXHTTPStringRequest path(String path) throws UnsupportedEncodingException {
        this.builder.path(path);
        return this;
    }

    public GXHTTPStringRequest header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public GXHTTPStringRequest queryParams(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.builder.queryParams(queryParams);
        return this;
    }
}

