/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxhttp.request;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.gcube.common.gxhttp.reference.GXHTTP;
import org.gcube.common.gxhttp.request.GXHTTPCommonRequest;

public class GXHTTPStreamRequest
extends GXHTTPCommonRequest
implements GXHTTP<InputStream, HttpURLConnection> {
    private GXHTTPStreamRequest(String address) {
        this.builder.connection = new GXConnection(address);
    }

    public static GXHTTPStreamRequest newRequest(String address) {
        return new GXHTTPStreamRequest(address);
    }

    @Override
    public HttpURLConnection put(InputStream body) throws Exception {
        if (Objects.nonNull(body)) {
            this.builder.connection.addBodyAsStream(body);
        }
        logger.trace("Sending a PUT request...");
        return this.builder.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    @Override
    public HttpURLConnection post(InputStream body) throws Exception {
        logger.trace("Sending a POST request...");
        if (Objects.nonNull(body)) {
            this.builder.connection.addBodyAsStream(body);
        }
        return this.builder.connection.send(GXConnection.HTTPMETHOD.POST);
    }

    public GXHTTPStreamRequest from(String agent) {
        this.builder.from(agent);
        return this;
    }

    public GXHTTPStreamRequest path(String path) throws UnsupportedEncodingException {
        this.builder.path(path);
        return this;
    }

    public GXHTTPStreamRequest header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public GXHTTPStreamRequest queryParams(Map<String, String> queryParams) throws UnsupportedEncodingException {
        this.builder.queryParams(queryParams);
        return this;
    }
}

