package org.gcube.common.iam;

import org.gcube.common.keycloak.KeycloakClientException;

/**
 * Exception thrown by D4Science IAM client operations.
 * 
 * @author Luca Frosini (ISTI-CNR)
 */
public class D4ScienceIAMClientException extends Exception {

    private static final long serialVersionUID = 1L;

    /**
     * Creates a new exception with the specified cause.
     * 
     * @param cause the underlying cause
     */
    public D4ScienceIAMClientException(Throwable cause) {
        super(cause);
    }

    /**
     * Creates a new exception with the specified message and cause.
     * 
     * @param message the exception message
     * @param cause the underlying cause
     */
    public D4ScienceIAMClientException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Returns the HTTP status code if the cause is a KeycloakClientException.
     * 
     * @return the HTTP status code, or -1 if not available
     */
    public int getStatus() {
        return getCause() instanceof KeycloakClientException ? ((KeycloakClientException) getCause()).getStatus() : -1;
    }

    /**
     * Returns the content type if the cause is a KeycloakClientException.
     * 
     * @return the content type, or null if not available
     */
    public String getContentType() {
        return getCause() instanceof KeycloakClientException ? ((KeycloakClientException) getCause()).getContentType()
                : null;
    }

    /**
     * Checks if the response has a JSON payload.
     * 
     * @return true if the response has a JSON payload, false otherwise
     */
    public boolean hasJSONPayload() {
        return getCause() instanceof KeycloakClientException ? ((KeycloakClientException) getCause()).hasJSONPayload()
                : false;
    }

    /**
     * Returns the response string if the cause is a KeycloakClientException.
     * 
     * @return the response string, or null if not available
     */
    public String getResponseString() {
        return getCause() instanceof KeycloakClientException
                ? ((KeycloakClientException) getCause()).getResponseString()
                : null;
    }

}
