/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.policies;

import java.util.Calendar;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.library.policies.Action;
import org.gcube.common.authorization.library.policies.Policy;
import org.gcube.common.authorization.library.policies.PolicyType;
import org.gcube.common.authorization.library.policies.ServiceAccess;
import org.gcube.common.authorization.library.policies.ServiceEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Service2ServicePolicy
extends Policy {
    private ServiceEntity client;
    private String context;
    private Calendar lastUpdateTime;
    private Calendar creationTime;
    private ServiceAccess serviceAccess;
    private Action mode = Action.ALL;

    protected Service2ServicePolicy() {
    }

    public Service2ServicePolicy(String context, ServiceAccess serviceAccess, ServiceEntity client) {
        this.context = context;
        this.serviceAccess = serviceAccess;
        this.client = client;
    }

    public Service2ServicePolicy(String context, ServiceAccess serviceAccess, ServiceEntity client, Action mode) {
        this(context, serviceAccess, client);
        this.mode = mode;
    }

    @Override
    public PolicyType getPolicyType() {
        return PolicyType.SERVICE;
    }

    @Override
    public String getPolicyAsString() {
        return this.context + "," + this.serviceAccess.getAsString() + "," + this.client.getAsString() + "," + this.mode.toString();
    }

    public ServiceEntity getClient() {
        return this.client;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public ServiceAccess getServiceAccess() {
        return this.serviceAccess;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.client == null ? 0 : this.client.hashCode());
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.serviceAccess == null ? 0 : this.serviceAccess.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Service2ServicePolicy other = (Service2ServicePolicy)obj;
        if (this.client == null ? other.client != null : !this.client.equals(other.client)) {
            return false;
        }
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        return !(this.serviceAccess == null ? other.serviceAccess != null : !this.serviceAccess.equals(other.serviceAccess));
    }

    public String toString() {
        return "Service2ServicePolicy [id=" + this.getId() + " client=" + String.valueOf(this.client) + ", context=" + this.context + ", serviceAccess=" + String.valueOf(this.serviceAccess) + ", mode=" + String.valueOf((Object)this.mode) + "]";
    }

    @Override
    public Action getMode() {
        return this.mode;
    }

    @Override
    public Calendar getCreationTime() {
        return this.creationTime;
    }

    @Override
    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(Calendar lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public void setCreationTime(Calendar creationTime) {
        this.creationTime = creationTime;
    }
}

