/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.secret;

import java.util.Map;
import java.util.Objects;
import org.gcube.common.authorization.library.ClientType;
import org.gcube.common.authorization.library.exception.AuthorizationException;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.authorization.utils.user.User;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Secret
implements Comparable<Secret> {
    protected static final Logger logger = LoggerFactory.getLogger(Secret.class);
    protected int priority;
    protected String token;
    protected User user;

    protected void check(String token) throws AuthorizationException {
        if (token == null) {
            throw new AuthorizationException("token cannot be null");
        }
        if (token.compareTo("") == 0) {
            throw new AuthorizationException("token cannot be an empty string");
        }
    }

    protected Secret(int priority, String token) {
        this.priority = priority;
        this.check(token);
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void set() throws Exception {
        this.setToken();
        this.setAuthorizationProvider();
        ScopeProvider.instance.set(this.getContext());
    }

    public abstract void setToken() throws Exception;

    public abstract void resetToken() throws Exception;

    public abstract ClientInfo getClientInfo() throws Exception;

    public abstract Caller getCaller() throws Exception;

    public void setAuthorizationProvider() throws Exception {
        Caller caller = this.getCaller();
        AuthorizationProvider.instance.set(caller);
    }

    public abstract String getContext() throws Exception;

    public String getUsername() throws Exception {
        return this.getClientInfo().getId();
    }

    public boolean isApplication() throws Exception {
        return this.getClientInfo().getType() == ClientType.EXTERNALSERVICE;
    }

    public abstract Map<String, String> getHTTPAuthorizationHeaders();

    public int hashCode() {
        return Objects.hash(this.priority, this.token);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Secret other = (Secret)obj;
        return this.priority == other.priority && Objects.equals(this.token, other.token);
    }

    @Override
    public int compareTo(Secret obj) {
        if (this == obj) {
            return 0;
        }
        if (obj == null) {
            return this.priority;
        }
        if (this.getClass() != obj.getClass()) {
            return this.priority;
        }
        return this.token.compareTo(obj.token);
    }

    public void reset() throws Exception {
        this.resetToken();
        AuthorizationProvider.instance.reset();
        ScopeProvider.instance.reset();
    }

    public abstract boolean isExpired() throws Exception;

    public abstract boolean isRefreshable() throws Exception;

    public abstract User getUser();
}

