/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.accounting.summary.access.impl;

import java.security.Key;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.gcube.accounting.accounting.summary.access.impl.ConnectionManager;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.user.User;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConnectionManager
implements ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(BasicConnectionManager.class);
    private static final ConcurrentHashMap<String, DataBaseDescriptor> cache = new ConcurrentHashMap();

    private synchronized DataBaseDescriptor getDatabase() {
        try {
            log.info("Looking for database, checking caller context..");
            SecretManager cm = SecretManagerProvider.instance.get();
            final String context = cm.getContext();
            User user = cm.getUser();
            log.info("Identified caller {} in context {}", (Object)user.getUsername(), (Object)context);
            return cache.computeIfAbsent(context, new Function<String, DataBaseDescriptor>(){

                @Override
                public DataBaseDescriptor apply(String t) {
                    try {
                        log.info("Database for {}  not found in cache. Querying IS .. ", (Object)context);
                        SecretManager cm = SecretManagerProvider.instance.get();
                        String context2 = cm.getContext();
                        User user = cm.getUser();
                        log.debug("CACHE FUNCTION : Identified caller {} in context {}", (Object)user.getUsername(), (Object)context2);
                        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
                        query.addCondition("$resource/Profile/Category/text() eq 'Database'").addCondition("$resource/Profile/Name/text() eq 'AccountingDashboard'");
                        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
                        ServiceEndpoint endpoint = (ServiceEndpoint)client.submit((Query)query).get(0);
                        log.debug("Found SE id {} ", (Object)endpoint.id());
                        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)endpoint.profile().accessPoints().iterator().next();
                        return new DataBaseDescriptor(ap.address(), ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]), System.currentTimeMillis());
                    }
                    catch (Throwable th) {
                        throw new RuntimeException("Unable to load Database credentials under context " + context, th);
                    }
                }
            });
        }
        catch (Exception t) {
            throw new RuntimeException("Unable to get DB Descriptor ", t);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        DataBaseDescriptor db = this.getDatabase();
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Connection conn = DriverManager.getConnection(db.getUrl(), db.getUser(), db.getPassword());
        conn.setAutoCommit(false);
        return conn;
    }

    private static class DataBaseDescriptor {
        private String url;
        private String user;
        private String password;
        private long loadedTimestamp;

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public long getLoadedTimestamp() {
            return this.loadedTimestamp;
        }

        public DataBaseDescriptor(String url, String user, String password, long loadedTimestamp) {
            this.url = url;
            this.user = user;
            this.password = password;
            this.loadedTimestamp = loadedTimestamp;
        }
    }
}

