/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcube.accounting.aggregator.utility.Utility;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkSpaceManagement {
    public static Logger logger = LoggerFactory.getLogger(WorkSpaceManagement.class);
    private static final String ZIP_SUFFIX = ".zip";
    private static final String ZIP_FILE_DESCRIPTION = "Backup of original records deleted and aggregtaed records inserted.";
    private static final String ZIP_MIMETYPE = "application/zip, application/octet-stream";
    protected StorageHubClient storageHubClient = new StorageHubClient();

    public static WorkSpaceManagement getInstance() {
        return new WorkSpaceManagement();
    }

    protected WorkSpaceManagement() {
    }

    public void addToZipFile(ZipOutputStream zos, File file) throws Exception {
        int len;
        byte[] buffer = new byte[1024];
        FileInputStream in = new FileInputStream(file);
        ZipEntry ze = new ZipEntry(file.getName());
        zos.putNextEntry(ze);
        while ((len = in.read(buffer)) > 0) {
            zos.write(buffer, 0, len);
        }
        zos.closeEntry();
        in.close();
    }

    private String getZipFileName(String name) throws Exception {
        String zipFileName = "%s%s".formatted(name, ZIP_SUFFIX);
        return zipFileName;
    }

    public boolean zipAndBackupFiles(FolderContainer targetFolder, String name, List<File> files) throws Exception {
        try {
            String zipFileName = this.getZipFileName(name);
            File zipFile = new File(files.get(0).getParentFile(), zipFileName);
            zipFile.delete();
            logger.trace("Going to save {} into workspace", (Object)zipFile.getAbsolutePath());
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (File file : files) {
                this.addToZipFile(zos, file);
            }
            zos.close();
            FileInputStream zipFileStream = new FileInputStream(zipFile);
            WorkSpaceManagement.getInstance().uploadFile(zipFileStream, zipFileName, ZIP_FILE_DESCRIPTION, ZIP_MIMETYPE, targetFolder);
            logger.debug("Going to delete local zip file {}", (Object)zipFile.getAbsolutePath());
            zipFile.delete();
            for (File file : files) {
                if (!file.exists()) continue;
                logger.debug("Going to delete local file {} which was added to the zip file {}", (Object)file.getAbsolutePath(), (Object)zipFile.getAbsolutePath());
                file.delete();
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Error while trying to save a backup file containg aggregated records", (Throwable)e);
            throw e;
        }
    }

    public FolderContainer getWorkspaceRoot() throws Exception {
        try {
            return this.storageHubClient.getWSRoot();
        }
        catch (Exception e) {
            String username = Utility.getUsername();
            logger.info("Unable to create the Workspace Root for {}.", (Object)username);
            throw e;
        }
    }

    protected FolderContainer getFolder(FolderContainer parent, String name) throws StorageHubException {
        ItemContainer itemContainer;
        FolderContainer destinationFolder = null;
        ListResolver listResolver = parent.findByName(name);
        List itemContainers = listResolver.getContainers();
        if (itemContainers.size() >= 1 && (itemContainer = (ItemContainer)itemContainers.get(0)).getType().compareTo((Enum)ContainerType.FOLDER) == 0) {
            destinationFolder = (FolderContainer)itemContainer;
        }
        return destinationFolder;
    }

    public FolderContainer getOrCreateFolder(FolderContainer parent, String name, String description, boolean hidden) throws Exception {
        FolderContainer destinationFolder = this.getFolder(parent, name);
        if (destinationFolder == null) {
            destinationFolder = hidden ? parent.newHiddenFolder(name, description) : parent.newFolder(name, description);
        }
        return destinationFolder;
    }

    public FileContainer uploadFile(InputStream inputStream, String fileName, String description, String mimeType, FolderContainer parentPath) throws Exception {
        try {
            logger.trace("Going to upload file on WorkSpace name:{}, description:{}, mimetype:{}, parentPath:{}", new Object[]{fileName, description, mimeType, parentPath});
            FileContainer filecontainer = parentPath.uploadFile(inputStream, fileName, description);
            logger.info("Zip file {} successfully uploaded in workspace", (Object)fileName);
            return filecontainer;
        }
        catch (Exception e) {
            logger.error("Error while uploading file on WorkSpace", (Throwable)e);
            throw e;
        }
    }
}

