/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.shibboleth;

import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.BaseFilter;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import gr.cite.additionalemailaddresses.CheckAdditionalEmailAddresses;
import gr.cite.shibboleth.model.EduUser;
import gr.cite.shibboleth.util.LoginHookEssentialMethods;
import gr.cite.shibboleth.util.ShibbolethSpecificMethods;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.portal.landingpage.LandingPageManager;

public class ShibbolethSamlFilter
extends BaseFilter {
    private static final Log log = LogFactoryUtil.getLog(ShibbolethSamlFilter.class);

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        HttpSession session = request.getSession();
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Boolean canCreateAccount = PrefsPropsUtil.getBoolean((long)companyId, (String)"company.security.strangers");
        User user = null;
        String landingPage = null;
        EduUser eduUser = ShibbolethSpecificMethods.createUser((HttpServletRequest)request);
        if (eduUser == null) {
            log.error((Object)"Could not create user object");
            return;
        }
        log.debug((Object)("Email: " + eduUser.getEmail()));
        log.debug((Object)("FirstName: " + eduUser.getName()));
        log.debug((Object)("LastName: " + eduUser.getSurName()));
        try {
            user = CheckAdditionalEmailAddresses.checkInIfAdditionalEmailAndIfVerified((String)eduUser.getEmail());
        }
        catch (Exception e) {
            log.error((Object)"Error occured while searching in additional emails", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        if (user != null) {
            log.debug((Object)("Email " + eduUser.getEmail() + " has been found in additional Email Addresses"));
            session.setAttribute("shibbolethEmail", (Object)user.getEmailAddress());
        } else if (canCreateAccount.booleanValue()) {
            LoginHookEssentialMethods.addUser((HttpSession)session, (long)companyId, (EduUser)eduUser);
            user = UserLocalServiceUtil.getUserById((long)UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)eduUser.getEmail()).getUserId());
        } else {
            try {
                user = UserLocalServiceUtil.getUserByEmailAddress((long)companyId, (String)eduUser.getEmail());
                log.debug((Object)("Login user " + user.getFullName() + " email address " + user.getEmailAddress()));
                session.setAttribute("shibbolethEmail", (Object)user.getEmailAddress());
            }
            catch (PortalException e) {
                SessionErrors.add((HttpSession)session, NoSuchUserException.class);
            }
        }
        String customRedirect = null;
        if (session.getAttribute("PORTLET_RENDER_PARAMETERS_") != null) {
            ConcurrentHashMap map = (ConcurrentHashMap)session.getAttribute("PORTLET_RENDER_PARAMETERS_");
            for (Long el : map.keySet()) {
                ConcurrentHashMap theMapValue = (ConcurrentHashMap)map.get(el);
                for (String key : theMapValue.keySet()) {
                    HashMap map2;
                    String[] vulo;
                    if (key.compareTo("58") != 0 || (vulo = (String[])(map2 = (HashMap)theMapValue.get(key)).get("_58_redirect")) == null || vulo.length <= 0) continue;
                    customRedirect = vulo[0];
                }
            }
        }
        if (customRedirect == null) {
            System.out.println("customRedirect not found, call getLandingPagePath");
            landingPage = LandingPageManager.getLandingPagePath((HttpServletRequest)request, (User)user);
            response.sendRedirect(landingPage);
        } else {
            System.out.println("customRedirect found");
            response.sendRedirect(customRedirect);
        }
    }

    protected Log getLog() {
        return log;
    }
}

