/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.windowslive.scribe;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verifier;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.oauth.OAuthService;
import gr.cite.windowslive.scribe.DefaultApiMy;

public class OAuthMyService
extends OAuth20Service {
    private static final String VERSION = "2.0";
    private final DefaultApiMy api;

    public OAuthMyService(DefaultApiMy api, OAuthConfig config) {
        super((DefaultApi20)api, config);
        this.api = api;
    }

    public final Token getAccessTokenWithPost(Verifier verifier) {
        OAuthConfig config = this.getConfig();
        OAuthRequest oAuthRequest = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), (OAuthService)this);
        oAuthRequest.addBodyParameter("grant_type", "authorization_code");
        oAuthRequest.addBodyParameter("client_id", config.getApiKey());
        oAuthRequest.addBodyParameter("client_secret", config.getApiSecret());
        oAuthRequest.addBodyParameter("redirect_uri", config.getCallback());
        oAuthRequest.addBodyParameter("code", verifier.getValue());
        Response response = ((OAuthRequest)this.createAccessTokenRequest(verifier, (AbstractRequest)oAuthRequest)).send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    protected <T extends AbstractRequest> T createAccessTokenRequest(Verifier verifier, T request) {
        OAuthConfig config = this.getConfig();
        request.addParameter("client_id", config.getApiKey());
        request.addParameter("client_secret", config.getApiSecret());
        request.addParameter("code", verifier.getValue());
        request.addParameter("redirect_uri", config.getCallback());
        if (config.hasScope()) {
            request.addParameter("scope", config.getScope());
        }
        if (config.hasGrantType()) {
            request.addParameter("grant_type", config.getGrantType());
        }
        return request;
    }

    public String getVersion() {
        return VERSION;
    }

    public void signRequest(Token accessToken, AbstractRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }

    public String getAuthorizationUrl() {
        return this.api.getAuthorizationUrl(this.getConfig());
    }

    public DefaultApiMy getApi() {
        return this.api;
    }
}

