package org.gcube.social_networking.socialnetworking.model.beans.workspace;

import java.util.Arrays;
import java.util.List;

import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;

import jakarta.validation.constraints.NotNull;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonTypeName("FOLDER_ADDEDUSER")
public class FolderAddedUserEvent extends WorkspaceEvent {
	private static final WorkspaceEventType TYPE = WorkspaceEventType.FOLDER_ADDEDUSER;
	@JsonProperty("folderItem")
	@NotNull(message = "folderItem cannot be missing")
	private FolderBean folder;

	@JsonProperty("newAddedUserIds")
	@NotNull(message = "newAddedUserIds cannot be missing")
	private List<String> newAddedUserIds;

	public FolderAddedUserEvent() {
		super(TYPE);
	}

	/**
	 * 
	 * @param idsToNotify     usernames
	 * @param idsAsGroup      true if idsToNotify are groups (members of contexts)
	 * @param folder          the folder
	 * @param newAddedUserIds list of usernames
	 */
	public FolderAddedUserEvent(String[] idsToNotify, boolean idsAsGroup, FolderBean folder,
			List<String> newAddedUserIds) {
		super(TYPE);
		this.idsToNotify = idsToNotify;
		this.idsAsGroup = idsAsGroup;
		this.newAddedUserIds = newAddedUserIds;
		this.folder = folder;
	}

	/**
	 * 
	 * @param idsToNotify usernames
	 * @param folder      the folder
	 */
	public FolderAddedUserEvent(String[] idsToNotify, FolderBean folder, List<String> newAddedUserIds) {
		super(TYPE);
		this.idsToNotify = idsToNotify;
		this.newAddedUserIds = newAddedUserIds;
		this.folder = folder;
	}

	public FolderBean getFolder() {
		return folder;
	}

	public void setFolder(FolderBean folder) {
		this.folder = folder;
	}

	public List<String> getNewAddedUserIds() {
		return newAddedUserIds;
	}

	public void setNewAddedUserIds(List<String> newAddedUserIds) {
		this.newAddedUserIds = newAddedUserIds;
	}

	@Override
	public String toString() {
		return "FolderAddedUserEvent [folder=" + folder + ", newAddedUserIds=" + newAddedUserIds + ", TYPE=" + TYPE
				+ ", idsToNotify=" + Arrays.toString(idsToNotify) + ", idsAsGroup=" + idsAsGroup + "]";
	}

}
