package org.gcube.common.security.secrets;

import java.util.Map;

import org.gcube.common.iam.D4ScienceIAMClient;
import org.gcube.common.iam.D4ScienceIAMClientAuthn;
import org.gcube.common.iam.D4ScienceIAMClientAuthz;
import org.gcube.common.iam.D4ScienceIAMClientException;
import org.gcube.common.security.Owner;

public class CredentialSecret extends Secret {

    protected boolean initialised = false;

    private String username;
    private String password;
    private String context;
    private UmaTokenSecret accessTokenSecret;

    public CredentialSecret(String username, String password, String context) {
        this.username = username;
        this.password = password;
        this.context = context;
        init();
    }

    private void init() {
        refreshAccessToken();
    }

    private void refreshAccessToken() {
        try {
            D4ScienceIAMClient client = D4ScienceIAMClient.newInstance(context);
            D4ScienceIAMClientAuthn authn = client.authenticateUser(username, password, context);
            D4ScienceIAMClientAuthz authz = authn.authorize(context, null);
            this.accessTokenSecret = new UmaTokenSecret(authz.getAccessTokenString());
        } catch (D4ScienceIAMClientException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int priority() {
        return this.accessTokenSecret.priority();
    }

    @Override
    public Owner getOwner() {
        return this.accessTokenSecret.getOwner();
    }

    @Override
    public String getContext() {
        if (isExpired())
            refreshAccessToken();
        return this.accessTokenSecret.getContext();
    }

    @Override
    public Map<String, String> getHTTPAuthorizationHeaders() {
        if (this.accessTokenSecret.isExpired())
            refreshAccessToken();
        return this.accessTokenSecret.getHTTPAuthorizationHeaders();
    }

    @Override
    public boolean isExpired() {
        return this.accessTokenSecret.isExpired();
    }

    @Override
    public boolean isValid() {
        return this.accessTokenSecret.isValid();
    }
}
