/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.iam.D4ScienceIAMClient;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.GCubeJWTObject;
import org.gcube.common.security.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmaTokenSecret
extends Secret {
    private static final Logger log = LoggerFactory.getLogger(UmaTokenSecret.class);
    public static final int KEYCLOAK_BASED_SECRET_PRIORITY = 20;
    private static final String AUTH_HEADER = "Authorization";
    private static final String USER_HEADER = "d4s-user";
    private String encodedUmaToken;
    private Owner owner;
    private String context;
    private AccessToken accessToken;
    private boolean initialised = false;

    public UmaTokenSecret(String encodedUmaToken) {
        this.encodedUmaToken = encodedUmaToken;
    }

    public int priority() {
        return 20;
    }

    public Owner getOwner() {
        this.init();
        return this.owner;
    }

    public String getContext() {
        this.init();
        return this.context;
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
        authorizationHeaders.put(AUTH_HEADER, "Bearer " + this.encodedUmaToken);
        String encodedUser = Base64.getEncoder().encodeToString(this.getOwner().getId().getBytes());
        authorizationHeaders.put(USER_HEADER, encodedUser);
        return authorizationHeaders;
    }

    protected String getEncodedUmaToken() {
        return this.encodedUmaToken;
    }

    public boolean isExpired() {
        this.init();
        return this.accessToken.isExpired();
    }

    private synchronized void init() {
        if (!this.initialised) {
            try {
                String realAccessTokenEncoded = this.encodedUmaToken.split("\\.")[1];
                String decodedAccessPart = new String(Base64.getDecoder().decode(realAccessTokenEncoded.getBytes()));
                ObjectMapper objectMapper = new ObjectMapper();
                this.accessToken = (AccessToken)objectMapper.readValue(decodedAccessPart, AccessToken.class);
                GCubeJWTObject obj = (GCubeJWTObject)objectMapper.readValue(decodedAccessPart, GCubeJWTObject.class);
                this.owner = new Owner(obj.getUsername(), obj.getRoles(), obj.getRealmRoles(), obj.getEmail(), obj.getFirstName(), obj.getLastName(), obj.isExternalService(), obj.isApplication());
                this.owner.setClientName(obj.getClientName());
                this.owner.setContactOrganisation(obj.getContactOrganisation());
                this.owner.setClientName(obj.getClientName());
                this.context = obj.getContext();
                this.initialised = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isValid() {
        this.init();
        try {
            D4ScienceIAMClient client = D4ScienceIAMClient.newInstance((String)this.context);
            client.verifyToken(this.encodedUmaToken);
            return true;
        }
        catch (Exception e) {
            log.error("Error contacting keycloak, is not possible to check token validity", (Throwable)e);
            return false;
        }
    }
}

