/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security;

import java.util.ArrayList;
import java.util.List;

public class Owner {
    private String id;
    private List<String> roles = new ArrayList<String>();
    private List<String> globalRoles = new ArrayList<String>();
    private List<String> contextRoles = new ArrayList<String>();
    private String email;
    private String firstName;
    private String lastName;
    private boolean externalClient;
    private String clientName;
    private String contactPerson;
    private String contactOrganisation;
    private boolean application;

    public Owner(String id, List<String> contextRoles, boolean external, boolean application) {
        this.id = id;
        this.contextRoles = contextRoles;
        this.roles.addAll(contextRoles);
        this.externalClient = external;
        this.application = application;
    }

    public Owner(String id, List<String> contextRoles, String email, String firstName, String lastName, boolean external, boolean application) {
        this(id, contextRoles, external, application);
        this.email = email;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public Owner(String id, List<String> contextRoles, List<String> globalRoles, String email, String firstName, String lastName, boolean external, boolean application) {
        this(id, contextRoles, email, firstName, lastName, external, application);
        this.globalRoles = globalRoles;
        this.roles.addAll(globalRoles);
    }

    public boolean isApplication() {
        return this.application;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<String> getGlobalRoles() {
        return this.globalRoles;
    }

    public List<String> getContextRoles() {
        return this.contextRoles;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public boolean isExternalClient() {
        return this.externalClient;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactOrganisation() {
        return this.contactOrganisation;
    }

    public void setContactOrganisation(String contactOrganisation) {
        this.contactOrganisation = contactOrganisation;
    }
}

