/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.client;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.client.SmartExecutorClient;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.json.SEMapper;
import org.gcube.vremanagement.executor.plugin.PluginDefinition;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.ScheduledTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartExecutorClientImpl
implements SmartExecutorClient {
    private static final Logger logger = LoggerFactory.getLogger(SmartExecutorClientImpl.class);
    public static final String PATH_SEPARATOR = "/";
    protected String pluginName;
    protected String host;
    protected String address;

    public static String getHostFromCompleteURL(String address) {
        return address.split("(http)s{0,1}://")[1].split(":")[0];
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.host = SmartExecutorClientImpl.getHostFromCompleteURL(address);
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    protected static StringBuilder getStringBuilder(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
        }
        return result;
    }

    protected GXHTTPStringRequest getGXHTTPStringRequest() {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
        gxHTTPStringRequest.from(SmartExecutorClient.class.getSimpleName());
        Secret secret = SecretManagerProvider.get();
        Map authHeader = secret.getHTTPAuthorizationHeaders();
        if (authHeader != null && !authHeader.isEmpty()) {
            for (Map.Entry entry : authHeader.entrySet()) {
                gxHTTPStringRequest.header((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            logger.warn("No authentication header found for SmartExecutorClient. This may lead to unauthorized access.");
        }
        return gxHTTPStringRequest;
    }

    protected String parseHttpURLConnection(HttpURLConnection connection) throws WebApplicationException {
        try {
            int responseCode = connection.getResponseCode();
            if (connection.getRequestMethod().compareTo(GXConnection.HTTPMETHOD.HEAD.toString()) == 0) {
                if (responseCode == 204) {
                    String string = null;
                    return string;
                }
                if (responseCode == 404) {
                    throw new NotFoundException();
                }
                if (responseCode == 403) {
                    throw new ForbiddenException();
                }
            }
            if (responseCode >= 400) {
                InputStream inputStream = connection.getErrorStream();
                StringBuilder result = SmartExecutorClientImpl.getStringBuilder(inputStream);
                String res = result.toString();
                throw new WebApplicationException(res, responseCode);
            }
            StringBuilder result = SmartExecutorClientImpl.getStringBuilder(connection.getInputStream());
            String string = result.toString();
            return string;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            connection.disconnect();
        }
    }

    private void checkPluginName(String pluginName) throws ExecutorException {
        if (pluginName.compareTo(this.pluginName) != 0) {
            throw new ExecutorException("The client has been instantiated for %s so it cannot be used to launch %s".formatted(this.pluginName, pluginName));
        }
    }

    @Override
    public String getAvailablePlugins() {
        try {
            logger.info("Going to get Available Plugins on {}", (Object)this.host);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("plugins");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String pluginList = this.parseHttpURLConnection(httpURLConnection);
            logger.info("Available Plugins on {} are {}", (Object)this.host, (Object)pluginList);
            return pluginList;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<PluginDefinition> getPlugins() throws IOException {
        String pluginList = this.getAvailablePlugins();
        return SEMapper.getInstance().unmarshalList(PluginDefinition.class, pluginList);
    }

    private String getScheduledTask(String name) {
        try {
            logger.info("Going to get {} scheduled tasks", (Object)name);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("plugins");
            gxHTTPStringRequest.path(name);
            gxHTTPStringRequest.path("executions");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String scheduledList = this.parseHttpURLConnection(httpURLConnection);
            logger.info("{} scheduled task are {}", (Object)name, (Object)scheduledList);
            return scheduledList;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getOrphanLaunches() {
        return this.getScheduledTask("ORPHAN");
    }

    @Override
    public List<ScheduledTask> getOrphanScheduledLaunches() throws IOException {
        String orphanList = this.getOrphanLaunches();
        return SEMapper.getInstance().unmarshalList(ScheduledTask.class, orphanList);
    }

    @Override
    public String getLaunches() {
        return this.getScheduledTask(this.pluginName);
    }

    @Override
    public List<ScheduledTask> getScheduledLaunches() throws IOException {
        String launchesList = this.getLaunches();
        return SEMapper.getInstance().unmarshalList(ScheduledTask.class, launchesList);
    }

    @Override
    public String launch(String launchParameter) {
        try {
            logger.info("Going to launch plugin {} on {} with parameters {} ", new Object[]{this.pluginName, this.host, launchParameter});
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header("Content-Type", "application/json;charset=UTF-8");
            gxHTTPStringRequest.header("Accept", "text/plain");
            gxHTTPStringRequest.path("plugins");
            gxHTTPStringRequest.path(this.pluginName);
            gxHTTPStringRequest.path("executions");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.post(launchParameter);
            String uuid = this.parseHttpURLConnection(httpURLConnection);
            logger.debug("Plugin {} launched on host {}. UUID to monitor the execution is {} ", new Object[]{this.pluginName, this.host, uuid});
            return uuid;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UUID launch(LaunchParameter launchParameter) {
        try {
            this.checkPluginName(launchParameter.getPluginName());
            String uuid = this.launch(SEMapper.getInstance().marshal((Object)launchParameter));
            return UUID.fromString(uuid);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getPluginStateEvolution(String executionIdentifier) {
        return this.getPluginStateEvolution(executionIdentifier, -1);
    }

    @Override
    public String getPluginStateEvolution(String executionIdentifier, int iterationNumber) {
        try {
            logger.info("Going to get {} of {} with UUID {} ", new Object[]{PluginStateEvolution.class.getSimpleName(), this.pluginName, executionIdentifier});
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("plugins");
            gxHTTPStringRequest.path(this.pluginName);
            gxHTTPStringRequest.path("executions");
            gxHTTPStringRequest.path(executionIdentifier);
            if (iterationNumber > 0) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("iteration", Integer.toString(iterationNumber));
                gxHTTPStringRequest.queryParams(parameters);
            }
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String pluginStateEvolution = this.parseHttpURLConnection(httpURLConnection);
            return pluginStateEvolution;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PluginStateEvolution getPluginStateEvolution(UUID executionIdentifier) {
        return this.getPluginStateEvolution(executionIdentifier, -1);
    }

    @Override
    public PluginStateEvolution getPluginStateEvolution(UUID executionIdentifier, int iterationNumber) {
        try {
            String pluginStateEvolution = this.getPluginStateEvolution(executionIdentifier.toString(), iterationNumber);
            return (PluginStateEvolution)SEMapper.getInstance().unmarshal(PluginStateEvolution.class, pluginStateEvolution);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(String executionIdentifier) {
        return this.delete(executionIdentifier.toString(), true);
    }

    @Override
    public boolean delete(String executionIdentifier, boolean unschedule) {
        try {
            logger.info("Going to stop plugin {} with UUID {} on host {}", new Object[]{this.pluginName, executionIdentifier, this.host});
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header("Accept", "text/plain");
            gxHTTPStringRequest.path("plugins");
            gxHTTPStringRequest.path(this.pluginName);
            gxHTTPStringRequest.path("executions");
            gxHTTPStringRequest.path(executionIdentifier);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("unschedule", Boolean.toString(unschedule));
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            this.parseHttpURLConnection(httpURLConnection);
            return true;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(UUID executionIdentifier) {
        return this.delete(executionIdentifier.toString(), true);
    }

    @Override
    public boolean delete(UUID executionIdentifier, boolean unschedule) {
        return this.delete(executionIdentifier.toString(), unschedule);
    }
}

