/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.shared;

import java.io.Serializable;
import java.util.List;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.Post;

public class PostWithAttachment
implements Serializable {
    private Post post;
    private List<Attachment> attachments;

    public PostWithAttachment(Post post, List<Attachment> attachments) {
        this.post = post;
        this.attachments = attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void setPost(Post post) {
        this.post = post;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Post getPost() {
        return this.post;
    }

    public String toString() {
        String postInfo = "Post [key=" + this.post.getKey() + ", type=" + String.valueOf((Object)this.post.getType()) + ", entityId=" + this.post.getEntityId() + ", time=" + String.valueOf(this.post.getTime()) + ", vreid=" + this.post.getVreid() + ", uri=" + this.post.getUri() + ", uriThumbnail=" + this.post.getUriThumbnail() + ", description=" + this.post.getDescription() + ", privacy=" + String.valueOf((Object)this.post.getPrivacy()) + ", fullName=" + this.post.getFullName() + ", email=" + this.post.getEmail() + ", thumbnailURL=" + this.post.getThumbnailURL() + ", commentsNo=" + this.post.getCommentsNo() + ", likesNo=" + this.post.getLikesNo() + ", linkTitle=" + this.post.getLinkTitle() + ", linkDescription=" + this.post.getLinkDescription() + ", linkHost=" + this.post.getLinkHost() + ", applicationFeed=" + this.post.isApplicationFeed() + ", multiFileUpload=" + this.post.isMultiFileUpload() + "]";
        Object attachmentInfo = "[Attachments: ";
        for (Attachment attachment : this.attachments) {
            attachmentInfo = (String)attachmentInfo + "[Attachment [key=" + attachment.getId() + ", uri=" + attachment.getUri() + ", name=" + attachment.getName() + ", description=" + attachment.getDescription() + ", thumbnailURL=" + attachment.getThumbnailURL() + ", mimeType=" + attachment.getMimeType() + "]],";
        }
        attachmentInfo = ((String)attachmentInfo).substring(0, ((String)attachmentInfo).length() - 1);
        attachmentInfo = (String)attachmentInfo + "]";
        return "[" + postInfo + ", " + (String)attachmentInfo + "]";
    }
}

