/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.rest.resources;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import java.util.UUID;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.rest.SharingPath;
import org.gcube.resourcemanagement.analyser.InstanceAnalyser;
import org.gcube.resourcemanagement.analyser.InstanceAnalyserFactory;
import org.gcube.resourcemanagement.context.RMTargetContext;
import org.gcube.resourcemanagement.context.TargetContext;
import org.gcube.resourcemanagement.resource.Instance;
import org.gcube.resourcemanagement.rest.BaseREST;

@Path(value="resources")
public class ResourceManager
extends BaseREST {
    public static final String RESOURCES_PATH_PART = "resources";
    public static final String CURRENT_CONTEXT_PATH_PART = "CURRENT_CONTEXT";
    public static final String TYPE_PATH_PARAMETER = "TYPE_NAME";
    public static final String UUID_PATH_PARAMETER = "UUID";

    @GET
    @Path(value="{TYPE_NAME}/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String uuid, @QueryParam(value="operation") SharingPath.SharingOperation operation) throws WebApplicationException, ResourceRegistryException {
        this.logger.info("Requested to read {} with id {} ", (Object)type, (Object)uuid);
        this.setAccountingMethod("ReadResource");
        InstanceAnalyser analyser = InstanceAnalyserFactory.getInstanceAnalyser((String)type, (UUID)UUID.fromString(uuid));
        Instance instance = analyser.read(operation);
        return instance.toString();
    }

    @POST
    @Path(value="/contexts/{CONTEXT_UUID}/{TYPE_NAME}/{UUID}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String addRemove(@PathParam(value="CONTEXT_UUID") String contextId, @PathParam(value="TYPE_NAME") String type, @PathParam(value="UUID") String instanceId, @QueryParam(value="operation") SharingPath.SharingOperation operation, @QueryParam(value="dryRun") @DefaultValue(value="false") Boolean dryRun, String json) throws WebApplicationException, ResourceRegistryException {
        StringBuffer calledMethod = new StringBuffer();
        if (dryRun == null) {
            dryRun = false;
        }
        if (dryRun.booleanValue()) {
            calledMethod.append("dryRun");
        }
        if (operation == SharingPath.SharingOperation.ADD) {
            this.logger.info("Requested {} {} with UUID {} to {} with UUID {}", new Object[]{dryRun != false ? "a dry run for adding" : "to add", type, instanceId, "Context", contextId});
            calledMethod.append("AddToContext");
        } else {
            this.logger.info("Requested {} {} with UUID {} from {} with UUID {}", new Object[]{dryRun != false ? "a dry run for removing" : "to remove", type, instanceId, "Context", contextId});
            calledMethod.append("RemoveFromContext");
        }
        this.setAccountingMethod(calledMethod.toString());
        UUID instanceUUID = UUID.fromString(instanceId);
        InstanceAnalyser analyser = InstanceAnalyserFactory.getInstanceAnalyser((String)type, (UUID)instanceUUID);
        Secret secret = SecretManagerProvider.get();
        String currentContext = secret.getContext();
        UUID contextUUID = UUID.fromString(contextId);
        RMTargetContext targetContext = new RMTargetContext(contextUUID);
        String targetContextPath = targetContext.getContextFullPath();
        Instance instance = null;
        if (operation == SharingPath.SharingOperation.ADD) {
            analyser.setTargetContext((TargetContext)targetContext);
            instance = analyser.add();
            this.logger.trace("Instance added to context {} from context {}: {}", new Object[]{targetContextPath, currentContext, instance});
        } else if (operation == SharingPath.SharingOperation.REMOVE) {
            if (currentContext.compareTo(targetContextPath) != 0) {
                throw new BadRequestException("The request must be executed from the same context where the resource must be removed");
            }
            instance = analyser.remove();
            this.logger.trace("Instance removed from context {}: {}", (Object)currentContext, (Object)instance);
        }
        return instance.toString();
    }
}

