/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.resource;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnyGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonAnySetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.resourcemanagement.resource.DerivatedRelatedResourceGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class Instance
implements Comparable<Instance> {
    private static Logger logger = LoggerFactory.getLogger(Instance.class);
    protected static Set<String> excludedFacetKeys = new HashSet<String>();
    @JsonIgnore
    protected ObjectMapper mapper = new ObjectMapper();
    protected UUID id;
    protected String type;
    protected Map<String, JsonNode> properties;
    protected Set<Instance> mandatoryRelatedResources;
    protected Set<DerivatedRelatedResourceGroup<Instance>> derivatedRelatedResources;
    protected List<IdentifiableElement> newInstances;
    protected List<ERElement> addedElements;

    public static <I extends Instance> Set<I> getAsInstances(Class<I> iClass, Collection<Resource> resources) throws WebApplicationException {
        HashSet<Instance> instances = new HashSet<Instance>();
        for (Resource r : resources) {
            Instance i = null;
            try {
                i = (Instance)iClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                i.setResource(r);
            }
            catch (Exception e) {
                StringBuffer error = new StringBuffer();
                error.append("Error while creating a new instance of ");
                error.append(iClass.getName());
                logger.error(error.toString(), (Throwable)e);
                throw new InternalServerErrorException(error.toString(), (Throwable)e);
            }
            instances.add(i);
        }
        return instances;
    }

    public static <I extends Instance> Set<I> getAsInstances(Class<I> iClass, Resource ... resources) throws WebApplicationException {
        HashSet<Instance> instances = new HashSet<Instance>();
        for (Resource r : resources) {
            Instance i = null;
            try {
                i = (Instance)iClass.getConstructor(r.getClass()).newInstance(r);
            }
            catch (Exception e) {
                StringBuffer error = new StringBuffer();
                error.append("Error while creating a new instance of ");
                error.append(iClass.getName());
                logger.error(error.toString(), (Throwable)e);
                throw new InternalServerErrorException(error.toString(), (Throwable)e);
            }
            instances.add(i);
        }
        return instances;
    }

    public Instance() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    protected abstract void setIdentifingProperties(Resource var1) throws WebApplicationException;

    public void setResource(Resource r) throws WebApplicationException {
        this.setID(r.getID());
        this.setType(r.getTypeName());
    }

    @JsonGetter(value="id")
    public UUID getID() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setID(UUID id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, JsonNode> properties) {
        this.properties = properties;
    }

    @JsonAnySetter
    public void addProperty(String key, JsonNode value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, JsonNode>();
        }
        this.properties.put(key, value);
    }

    @JsonGetter
    public Set<Instance> getMandatoryRelatedResources() {
        return this.mandatoryRelatedResources;
    }

    public void setMandatoryRelatedResources(Set<Instance> mandatoryRelatedResources) {
        this.mandatoryRelatedResources = mandatoryRelatedResources;
    }

    @JsonSetter
    public void addMandatoryRelatedResource(Instance instance) {
        if (this.mandatoryRelatedResources == null) {
            this.mandatoryRelatedResources = new HashSet<Instance>();
        }
        this.mandatoryRelatedResources.add(instance);
    }

    @JsonIgnore
    public void addMandatoryRelatedResources(Set<Instance> instances) {
        if (this.mandatoryRelatedResources == null) {
            this.mandatoryRelatedResources = new HashSet<Instance>();
        }
        this.mandatoryRelatedResources.addAll(instances);
    }

    @JsonGetter
    public Set<DerivatedRelatedResourceGroup<Instance>> getDerivatedRelatedResources() {
        return this.derivatedRelatedResources;
    }

    public void setDerivatedRelatedResources(Set<DerivatedRelatedResourceGroup<Instance>> derivatedRelatedResources) {
        this.derivatedRelatedResources = derivatedRelatedResources;
    }

    @JsonSetter
    public void addDerivatedRelatedResource(DerivatedRelatedResourceGroup<Instance> derivatedRelatedResource) {
        if (this.derivatedRelatedResources == null) {
            this.derivatedRelatedResources = new HashSet<DerivatedRelatedResourceGroup<Instance>>();
        }
        this.derivatedRelatedResources.add(derivatedRelatedResource);
    }

    @JsonIgnore
    public void addDerivatedRelatedResources(Set<DerivatedRelatedResourceGroup<Instance>> derivatedRelatedResources) {
        if (this.derivatedRelatedResources == null) {
            this.derivatedRelatedResources = new HashSet<DerivatedRelatedResourceGroup<Instance>>();
        }
        this.derivatedRelatedResources.addAll(derivatedRelatedResources);
    }

    @JsonGetter
    public List<IdentifiableElement> getNewInstances() {
        return this.newInstances;
    }

    public void setNewInstances(List<IdentifiableElement> newInstances) {
        this.newInstances = newInstances;
    }

    @JsonSetter
    public void addNewInstance(IdentifiableElement newInstance) {
        if (this.newInstances == null) {
            this.newInstances = new ArrayList<IdentifiableElement>();
        }
        this.newInstances.add(newInstance);
    }

    @JsonIgnore
    public void addNewInstances(List<IdentifiableElement> newInstances) {
        if (this.newInstances == null) {
            this.newInstances = new ArrayList<IdentifiableElement>();
        }
        if (newInstances != null && !newInstances.isEmpty()) {
            this.newInstances.addAll(newInstances);
        }
    }

    public String toString() {
        try {
            return this.mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            logger.error("Error while serializing the instance", (Throwable)e);
            return super.toString();
        }
    }

    public List<ERElement> getAddedElements() {
        return this.addedElements;
    }

    public void setAddedElements(List<ERElement> addedElements) {
        this.addedElements = addedElements;
    }

    public void addAddedElement(ERElement addedElement) {
        if (this.addedElements == null) {
            this.addedElements = new ArrayList<ERElement>();
        }
        this.addedElements.add(addedElement);
    }

    public void addAddedElements(List<ERElement> addedElements) {
        if (this.addedElements == null) {
            this.addedElements = new ArrayList<ERElement>();
        }
        if (addedElements != null && !addedElements.isEmpty()) {
            this.addedElements.addAll(addedElements);
        }
    }

    public void addAddedElements(ERElement ... addedElements) {
        if (this.addedElements == null) {
            this.addedElements = new ArrayList<ERElement>();
        }
        if (addedElements != null && addedElements.length > 0) {
            for (ERElement addedElement : addedElements) {
                this.addedElements.add(addedElement);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Instance other = (Instance)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public int compareTo(Instance o) {
        int idComparison = this.id.compareTo(o.id);
        if (idComparison != 0) {
            return idComparison;
        }
        return this.type.compareTo(o.type);
    }

    static {
        excludedFacetKeys.add("id");
        excludedFacetKeys.add("metadata");
        excludedFacetKeys.add("type");
        excludedFacetKeys.add("supertypes");
        excludedFacetKeys.add("expectedtype");
        excludedFacetKeys.add("contexts");
    }
}

