/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.queries.templates;

import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.queries.templates.reference.entities.QueryTemplate;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.templates.QueryTemplateAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.templates.QueryTemplateNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.base.ElementManagementUtility;
import org.gcube.informationsystem.resourceregistry.base.entities.EntityElementManagement;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.queries.templates.QueryTemplateEnvironment;
import org.gcube.informationsystem.resourceregistry.instances.model.Operation;
import org.gcube.informationsystem.resourceregistry.queries.json.JsonQuery;
import org.gcube.informationsystem.resourceregistry.rest.requests.RequestUtility;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.utils.OrientDBUtility;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTemplateManagement
extends EntityElementManagement<QueryTemplate, EntityType> {
    private static Logger logger = LoggerFactory.getLogger(QueryTemplateManagement.class);
    protected String name;
    protected JsonNode params;

    public QueryTemplateManagement() {
        super(AccessType.QUERY_TEMPLATE);
        this.typeName = "QueryTemplate";
    }

    public QueryTemplateManagement(ODatabaseDocument oDatabaseDocument) throws ResourceRegistryException {
        this();
        this.oDatabaseDocument = oDatabaseDocument;
        this.getWorkingEnvironment();
    }

    protected void checkERMatch() throws ResourceRegistryException {
        this.getOClass();
    }

    protected void checkNameMatch() throws ResourceRegistryException {
        String jsonName;
        if (this.jsonNode != null && this.name != null && this.name.compareTo(jsonName = this.jsonNode.get("name").asText()) != 0) {
            String error = "Name provided in json (%s) differs from the one (%s) used to identify the %s instance".formatted(jsonName, this.name, this.typeName);
            throw new ResourceRegistryException(error);
        }
    }

    public void setName(String name) throws ResourceRegistryException {
        this.name = name;
        this.checkNameMatch();
    }

    protected void checkJsonNode() throws ResourceRegistryException {
        super.checkJsonNode();
        this.checkNameMatch();
    }

    public String getName() {
        if (this.name == null) {
            if (this.element == null) {
                if (this.jsonNode != null) {
                    this.name = this.jsonNode.get("name").asText();
                }
            } else {
                this.name = (String)((OVertex)this.element).getProperty("name");
            }
        }
        return this.name;
    }

    protected Environment getWorkingEnvironment() throws ResourceRegistryException {
        if (this.workingEnvironment == null) {
            this.workingEnvironment = QueryTemplateEnvironment.getInstance();
        }
        return this.workingEnvironment;
    }

    protected JsonNode createCompleteJsonNode() throws ResourceRegistryException {
        try {
            JsonNode queryTemplate = this.serializeSelfAsJsonNode();
            ObjectMapper objectMapper = new ObjectMapper();
            String templateString = (String)((OVertex)this.element).getProperty("template");
            JsonNode templateJsonNode = objectMapper.readTree(templateString);
            ((ObjectNode)queryTemplate).replace("template", templateJsonNode);
            return queryTemplate;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    protected StringBuffer getSelectQuery() {
        StringBuffer select = new StringBuffer();
        select.append("SELECT FROM ");
        select.append("QueryTemplate");
        select.append(" WHERE ");
        select.append("name");
        select.append(" = ");
        select.append("\"");
        select.append(this.getName());
        select.append("\"");
        return select;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkIfNameAlreadyExists() throws QueryTemplateAlreadyPresentException {
        block6: {
            StringBuffer select = this.getSelectQuery();
            StringBuffer errorMessage = new StringBuffer();
            errorMessage.append("A ");
            errorMessage.append("QueryTemplate");
            errorMessage.append(" with ");
            errorMessage.append(this.getName());
            errorMessage.append(" already exists");
            logger.trace("Checking if {} -> {}", (Object)errorMessage, (Object)select);
            OResultSet resultSet = this.oDatabaseDocument.command(select.toString(), new HashMap());
            if (resultSet != null) {
                try {
                    if (!resultSet.hasNext()) break block6;
                    OResult oResult = resultSet.next();
                    try {
                        this.element = ElementManagementUtility.getElementFromOptional((Optional)oResult.getVertex());
                    }
                    catch (ResourceRegistryException resourceRegistryException) {
                        // empty catch block
                    }
                    throw new QueryTemplateAlreadyPresentException(errorMessage.toString());
                }
                finally {
                    resultSet.close();
                }
            }
        }
    }

    protected void tryTemplate() throws Exception {
        QueryTemplate queryTemplate = (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)this.jsonNode.toString());
        JsonNode jsonQueryNode = queryTemplate.getJsonQuery();
        JsonQuery jsonQuery = new JsonQuery();
        jsonQuery.setJsonQuery(jsonQueryNode);
        try {
            jsonQuery.query();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public OVertex retrieveElement() throws NotFoundException, ResourceRegistryException {
        try {
            StringBuffer select = this.getSelectQuery();
            OResultSet resultSet = this.oDatabaseDocument.query(select.toString(), new HashMap());
            if (resultSet == null || !resultSet.hasNext()) {
                if (resultSet != null) {
                    resultSet.close();
                }
                throw new QueryTemplateNotFoundException("Error retrieving QueryTemplate with name " + this.getName());
            }
            OResult oResult = resultSet.next();
            OVertex queryTemplate = (OVertex)ElementManagementUtility.getElementFromOptional((Optional)oResult.getVertex());
            logger.trace("{} representing vertex is {}", (Object)"QueryTemplate", (Object)OrientDBUtility.getAsStringForLogging((ORecord)queryTemplate));
            if (resultSet.hasNext()) {
                resultSet.close();
                throw new NotFoundException("Found more than one QueryTemplate with name " + this.name + ". This should not occur, please contact the administrator");
            }
            resultSet.close();
            return queryTemplate;
        }
        catch (NotFoundException e) {
            throw this.getSpecificNotFoundException(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String createOrUpdate() throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        try {
            this.oDatabaseDocument = this.getWorkingEnvironment().getDatabaseDocument(Environment.PermissionMode.WRITER);
            this.oDatabaseDocument.begin();
            boolean update = false;
            this.setAsEntryPoint();
            try {
                this.checkIfNameAlreadyExists();
                this.setOperation(Operation.CREATE);
                String calledMethod = InnerMethodName.get();
                calledMethod = calledMethod.replace("update", "create");
                InnerMethodName.set((String)calledMethod);
                this.internalCreate();
            }
            catch (QueryTemplateAlreadyPresentException e) {
                String jsonID;
                String uuidVertexString = ((OVertex)this.element).getProperty("id").toString();
                this.uuid = UUID.fromString(uuidVertexString);
                JsonNode idNode = this.jsonNode.get("id");
                if (idNode != null && !idNode.isNull() && idNode.isTextual() && uuidVertexString.compareTo(jsonID = idNode.asText()) != 0) {
                    throw new ResourceRegistryException("If you provide the id of the QueryTemplate it must has the same value of the id contained in the IS (i.e. " + uuidVertexString + ")");
                }
                this.setOperation(Operation.UPDATE);
                update = true;
                this.internalUpdate();
            }
            this.oDatabaseDocument.commit();
            if (update) {
                this.setReload(true);
            }
            String string = this.serializeAsJsonNode().toString();
            return string;
        }
        catch (ResourceRegistryException e) {
            logger.error("Unable to update {} with UUID {}", (Object)this.accessType.getName(), (Object)this.uuid);
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to update {} with UUID {}", new Object[]{this.accessType.getName(), this.uuid, e});
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.rollback();
            }
            throw new ResourceRegistryException((Throwable)e);
        }
        finally {
            if (this.oDatabaseDocument != null) {
                this.oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected OVertex reallyCreate() throws AlreadyPresentException, InvalidQueryException, ResourceRegistryException {
        try {
            this.checkIfNameAlreadyExists();
            this.tryTemplate();
            this.createVertex();
            return (OVertex)this.getElement();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.typeName, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.typeName + " with " + String.valueOf(this.jsonNode), e.getCause());
        }
    }

    protected OVertex reallyUpdate() throws NotFoundException, ResourceRegistryException {
        try {
            this.tryTemplate();
            OVertex queryTemplate = (OVertex)this.getElement();
            queryTemplate = (OVertex)this.updateProperties(this.oClass, (OElement)queryTemplate, this.jsonNode, this.ignoreKeys, this.ignoreStartWithKeys);
            return (OVertex)this.getElement();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.trace("Error while creating {} for {} ({}) using {}", new Object[]{OVertex.class.getSimpleName(), this.accessType.getName(), this.typeName, this.jsonNode, e});
            throw new ResourceRegistryException("Error Creating " + this.typeName + " with " + String.valueOf(this.jsonNode), e.getCause());
        }
    }

    protected void reallyDelete() throws NotFoundException, ResourceRegistryException {
        logger.debug("Going to delete {} with name {}", (Object)this.accessType.getName(), (Object)this.name);
        OVertex oVertex = (OVertex)this.getElement();
        this.uuid = UUID.fromString((String)oVertex.getProperty("id"));
        oVertex.delete();
    }

    protected NotFoundException getSpecificNotFoundException(NotFoundException e) {
        return new NotFoundException((Throwable)e);
    }

    protected AlreadyPresentException getSpecificAlreadyPresentException(String message) {
        return new AlreadyPresentException(message);
    }

    public String reallyGetAll(boolean polymorphic) throws ResourceRegistryException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayNode arrayNode = objectMapper.createArrayNode();
        ServerRequestInfo requestInfo = (ServerRequestInfo)RequestUtility.getRequestInfo().get();
        int limit = requestInfo.getLimit();
        int offset = requestInfo.getOffset();
        int position = -1;
        int count = 0;
        ORecordIteratorClass iterable = this.oDatabaseDocument.browseClass(this.typeName, polymorphic);
        for (ODocument vertex : iterable) {
            if (++position < offset) continue;
            QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
            queryTemplateManagement.setElement((OElement)((OVertex)vertex));
            try {
                JsonNode jsonObject = queryTemplateManagement.serializeAsJsonNode();
                arrayNode.add(jsonObject);
                if (limit <= 0 || ++count < limit) continue;
                break;
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to correctly serialize {}. It will be excluded from results. {}", (Object)vertex.toString(), (Object)"This is really strange and should not occur. Please contact the system administrator.");
            }
        }
        try {
            return objectMapper.writeValueAsString((Object)arrayNode);
        }
        catch (JsonProcessingException e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public void setParams(String params) throws ResourceRegistryException {
        try {
            if (params != null && params.compareTo("") != 0) {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(params);
                this.setParams(jsonNode);
            }
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public void setParams(JsonNode params) throws ResourceRegistryException {
        this.params = params;
    }

    public String run() throws ResourceRegistryException {
        try {
            String read = this.read();
            QueryTemplate queryTemplate = (QueryTemplate)ElementMapper.unmarshal(QueryTemplate.class, (String)read);
            JsonNode query = null;
            query = this.params != null ? queryTemplate.getJsonQuery(this.params) : queryTemplate.getJsonQuery();
            JsonQuery jsonQuery = new JsonQuery();
            jsonQuery.setJsonQuery(query);
            return jsonQuery.query();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public void sanityCheck() throws SchemaViolationException, ResourceRegistryException {
    }
}

