/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.rest;

import com.orientechnologies.orient.core.record.ODirection;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.ParameterIn;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameters;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.queries.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.request.BaseRequestInfo;
import org.gcube.informationsystem.resourceregistry.base.ElementManagement;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.contexts.entities.ContextManagement;
import org.gcube.informationsystem.resourceregistry.instances.model.ERManagementUtility;
import org.gcube.informationsystem.resourceregistry.instances.model.entities.ResourceManagement;
import org.gcube.informationsystem.resourceregistry.queries.QueryImpl;
import org.gcube.informationsystem.resourceregistry.queries.json.JsonQuery;
import org.gcube.informationsystem.resourceregistry.queries.templates.QueryTemplateManagement;
import org.gcube.informationsystem.resourceregistry.rest.BaseRest;
import org.gcube.informationsystem.resourceregistry.rest.Method;
import org.gcube.informationsystem.resourceregistry.rest.requests.ServerRequestInfo;
import org.gcube.informationsystem.resourceregistry.types.TypeManagement;
import org.gcube.informationsystem.types.TypeMapper;

@Path(value="access")
@Tag(name="Access", description="Resource Registry Access API - Provides read-only access to contexts, types, instances, and query execution")
public class Access
extends BaseRest {
    public static final String RESOURCE_TYPE_PATH_PARAMETER = "resource-type-name";
    public static final String RELATION_TYPE_PATH_PARAMETER = "relation-type-name";
    public static final String REFERENCE_TYPE_PATH_PARAMETER = "reference-type-name";
    public static final String RAW_QUERY_METHOD = "raw";
    public static final String GRAPH_QUERY_METHOD = "graph";
    public static final String JSON_QUERY_METHOD = "json";
    public static final String PREPARED_QUERY_METHOD = "prepared";

    @GET
    @Path(value="contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="List Contexts", description="Retrieves the list of contexts in the system.\n\nThe response can include metadata and provides pagination based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /access/contexts (returns first 10 contexts - default pagination);\n- GET /access/contexts?limit=20 (returns first 20 contexts);\n- GET /access/contexts?offset=10 (returns 10 contexts starting from the 11th - default limit with offset);\n- GET /access/contexts?limit=5&offset=15 (returns 5 contexts starting from the 16th);\n- GET /access/contexts?includeMeta=true (returns first 10 contexts with metadata - for non-admin users);\n- GET /access/contexts?limit=20&includeMeta=true (returns first 20 contexts with metadata).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Automatically receive full context information including:\n\t\t- Complete metadata (createdBy, lastUpdateBy, creation/modification dates);\n\t\t- Context state information;\n\t\t- All context properties without obfuscation.\n\t- Metadata is included by default regardless of request parameters.\n\n- **Infrastructure-Manager:**\n\t- Automatically receive full context information including:\n\t\t- Complete metadata (createdBy, lastUpdateBy, creation/modification dates);\n\t\t- Context state information;\n\t\t- All context properties without obfuscation.\n\t- Metadata is included by default regardless of request parameters.\n\n- **Other Users:**\n\t- Receive basic context information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive metadata with sensitive information filtered:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n")
    @Parameters(value={@Parameter(name="limit", in=ParameterIn.QUERY, description="Maximum number of contexts to return in a single response.\n- Default: 10 (returns at most 10 contexts);\n- Example: ?limit=50 (returns at most 50 contexts).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="10", example="10")), @Parameter(name="offset", in=ParameterIn.QUERY, description="Number of contexts to skip from the beginning of the result set.\n- Default: 0 (starts from the first context);\n- Example: ?offset=100 (skips the first 100 contexts);\n- Commonly used with limit for pagination: ?limit=50&offset=100.\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="0", example="0")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response (for non-admin users).\n- Default: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with obfuscated sensitive fields);\n- Note: IS-Manager and Infrastructure-Manager always receive not filtered metadata regardless of this parameter.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Contexts successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="403", description="User lacks authorization to access context information"), @APIResponse(responseCode="500", description="Server error during context retrieval")})
    public String listContexts() throws ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"Context");
        this.setAccountingMethod(Method.LIST, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo(BaseRequestInfo.DEFAULT_OFFSET.intValue(), BaseRequestInfo.UNBOUNDED_LIMIT.intValue());
        serverRequestInfo.setIncludeMeta(false);
        serverRequestInfo.setAllMeta(false);
        serverRequestInfo.checkLimitOffset();
        ContextManagement contextManagement = new ContextManagement();
        return contextManagement.all(false);
    }

    @GET
    @Path(value="contexts/{context-uuid}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Get Context by UUID", description="Retrieves a specific context by its UUID.\n\nThe response includes metadata and detail level based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /access/contexts/c0f314e7-2807-4241-a792-2a6c79ed4fd0 (returns basic context information);\n- GET /access/contexts/c0f314e7-2807-4241-a792-2a6c79ed4fd0?includeMeta=true (returns context with metadata - for non-admin users);\n- GET /access/contexts/CURRENT_CONTEXT (returns the current context - retrieved from client's authorization token).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can retrieve context information for any context without restrictions;\n\t- Automatically receive full context information including complete metadata;\n\t- All context properties and state information without obfuscation;\n\t- Metadata is included by default regardless of request parameters.\n\n- **Infrastructure-Manager:**\n\t- Can retrieve context information for any context without restrictions;\n\t- Automatically receive full context information including complete metadata;\n\t- All context properties and state information without obfuscation;\n\t- Metadata is included by default regardless of request parameters.\n\n- **Context-Manager:**\n\t- When operating in their own context (using a token from that context):\n\t\t- Receive full context information like IS-Manager and Infrastructure-Manager;\n\t\t- Complete metadata without obfuscation;\n\t\t- All context properties and state information.\n\t- When operating outside their context or requesting other contexts:\n\t\t- Receive basic context information by default;\n\t\t- Can request metadata via includeMeta=true with obfuscated sensitive fields.\n\n- **Other Users:**\n\t- Receive basic context information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive metadata with sensitive information filtered:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n")
    @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response (for non-admin users)\n- Default value: false (basic information only);\n- Values: true|false;\n- Example: ?includeMeta=true (includes metadata with obfuscated sensitive fields);\n- Note: IS-Manager and Infrastructure-Manager always receive metadata regardless of this parameter.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))
    @APIResponses(value={@APIResponse(responseCode="200", description="Context successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Context with the specified UUID does not exist"), @APIResponse(responseCode="403", description="User lacks authorization to access the specific context"), @APIResponse(responseCode="400", description="Invalid UUID format")})
    public String readContext(@PathParam(value="context-uuid") @Parameter(name="context-uuid", in=ParameterIn.PATH, description="The unique identifier of the context to retrieve.\n- Must be a valid UUID string format (e.g., \"c0f314e7-2807-4241-a792-2a6c79ed4fd0\");\n- Special keyword: \"CURRENT_CONTEXT\" to retrieve the context from client's authorization token;\n- When using \"CURRENT_CONTEXT\", the actual context is extracted from the JWT token sent by the client;\n- Example: GET /access/contexts/CURRENT_CONTEXT returns the context the client is authorized for.\n", required=true, schema=@Schema(type=SchemaType.STRING, example="c0f314e7-2807-4241-a792-2a6c79ed4fd0")) String uuid) throws ContextNotFoundException, ResourceRegistryException {
        if (uuid.compareTo("CURRENT_CONTEXT") == 0) {
            uuid = ContextUtility.getCurrentRequestEnvironment().getUUID().toString();
        }
        this.logger.info("Requested to read {} with id {} ", (Object)"Context", (Object)uuid);
        this.setAccountingMethod(Method.READ, "Context");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        ContextManagement contextManagement = new ContextManagement();
        contextManagement.setUUID(UUID.fromString(uuid));
        return contextManagement.readAsString();
    }

    @GET
    @Path(value="types/{type-name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Read Type Schema(s)", description="Get Type Schema Definition(s)\n\nRetrieves the schema definition(s) for the specified type. The response can include subtypes and metadata based on query parameters and user authorization.\n\n**Request Examples:**\n- GET /access/types/ContactFacet (returns basic ContactFacet type definition only);\n- GET /access/types/ContactFacet?polymorphic=true (returns ContactFacet and all its subtypes);\n- GET /access/types/ContactFacet?includeMeta=true (returns ContactFacet with metadata for authorized users);\n- GET /access/types/ContactFacet?polymorphic=true&includeMeta=true (returns ContactFacet, subtypes, and metadata).\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Receive basic type information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive complete type definitions with full metadata;\n\t- All metadata fields are included when includeMeta=true;\n\t- No obfuscation or filtering of sensitive information.\n\n- **Infrastructure-Manager:**\n\t- Receive basic type information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive complete type definitions with full metadata;\n\t- All metadata fields are included when includeMeta=true;\n\t- No obfuscation or filtering of sensitive information.\n\n- **Other Users:**\n\t- Receive basic type information by default;\n\t- Can explicitly request metadata via includeMeta=true query parameter;\n\t- When metadata is requested, receive metadata with sensitive information filtered:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n")
    @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response.\n- Default value: false (basic type information only);\n- Example: ?includeMeta=true (includes metadata based on user authorization).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))
    @APIResponses(value={@APIResponse(responseCode="200", description="Type successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Type with the specified name does not exist"), @APIResponse(responseCode="403", description="User lacks authorization to access type information")})
    public String readType(@PathParam(value="type-name") @Parameter(name="type-name", in=ParameterIn.PATH, description="The name of the type to retrieve (case-sensitive)", required=true, schema=@Schema(type=SchemaType.STRING, example="ContactFacet")) String type, @QueryParam(value="polymorphic") @DefaultValue(value="false") @Parameter(name="polymorphic", in=ParameterIn.QUERY, description="Whether to include subtypes in the response.\n- Default value: false (returns only the specified type);\n- When true: returns the specified type AND all its existing subtypes;\n- When false: returns only the specified type definition;\n- Note: No pagination is applied - ALL subtypes are returned when polymorphic=true;\n- Example: ?polymorphic=true (includes all subtypes of the requested type).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")) Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        this.logger.info("Requested Schema for type {}", (Object)type);
        this.setAccountingMethod(Method.READ, "Type");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        TypeManagement typeManagement = new TypeManagement();
        typeManagement.setTypeName(type);
        List types = typeManagement.read(polymorphic.booleanValue());
        try {
            return TypeMapper.serializeTypeDefinitions((List)types);
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @GET
    @Path(value="query-templates")
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="List Query Templates", description="Retrieves all query templates from the Resource Registry.\n\nThe response can include metadata and provides pagination based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /access/query-templates;\n- GET /access/query-templates?limit=20&offset=40;\n- GET /access/query-templates?includeMeta=true;\n- GET /access/query-templates?limit=15&offset=30&includeMeta=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to query templates;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to query templates;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Basic access with metadata filtering;\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n")
    @Parameters(value={@Parameter(name="limit", in=ParameterIn.QUERY, description="Maximum number of query templates to return in a single response.\n- Default value: 10;\n- Example: ?limit=50 (returns at most 50 query templates).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="10", example="10")), @Parameter(name="offset", in=ParameterIn.QUERY, description="Number of query templates to skip from the beginning of the result set.\n- Default value: 0 (starts from the first query template);\n- Example: ?offset=100 (skips the first 100 query templates).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="0", example="0")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response query templates.\n- Default value: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Restriction: IS-Manager and Infrastructure-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Query templates successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid query parameters (e.g., invalid limit/offset values)"), @APIResponse(responseCode="403", description="Insufficient permissions to access query templates")})
    public String listQueryTemplates() throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read all {}s", (Object)"QueryTemplate");
        this.setAccountingMethod(Method.LIST, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        serverRequestInfo.checkLimitOffset();
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        return queryTemplateManagement.all(false);
    }

    @GET
    @Path(value="query-templates/{query-template-name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Read Query Template", description="Retrieves a specific query template by its name from the Resource Registry.\n\nThe response includes metadata based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /access/query-templates/GetAllEServiceWithState;\n- GET /access/query-templates/GetAllEServiceWithState?includeMeta=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to query template;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to query template;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Basic access with metadata filtering;\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n")
    @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response query template\n- Default value: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Restriction: IS-Manager and Infrastructure-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))
    @APIResponses(value={@APIResponse(responseCode="200", description="Query template successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Query template with the specified name does not exist"), @APIResponse(responseCode="403", description="Insufficient permissions to access the query template")})
    public String readQueryTemplate(@PathParam(value="query-template-name") @Parameter(name="query-template-name", in=ParameterIn.PATH, description="The name of the query template to retrieve (e.g., \"GetAllEServiceWithState\")", required=true, schema=@Schema(type=SchemaType.STRING, example="GetAllEServiceWithState")) String queryTemplateName) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.READ, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.setAllMeta(true);
        serverRequestInfo.checkBooleanQueryParameter("includeMeta");
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        return queryTemplateManagement.read();
    }

    @POST
    @Path(value="query-templates/{query-template-name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Run Query Template", description="Executes a query template with the specified name and parameters in the Resource Registry.\n\nThe response includes metadata and supports advanced query features based on parameters and user authorization.\n\n\n**Request Examples:**\n- POST /access/query-templates/GetAllEServiceWithState;\n- POST /access/query-templates/GetAllEServiceWithState?polymorphic=false;\n- POST /access/query-templates/GetAllEServiceWithState?includeMeta=true;\n- POST /access/query-templates/GetAllEServiceWithState?hierarchical=true;\n- POST /access/query-templates/GetAllEServiceWithState?includeMeta=true&allMeta=true;\n- POST /access/query-templates/GetAllEServiceWithState?includeContexts=true.\n\n\n**Operation Behavior:**\n- Parameter Substitution: Parameters in the template query (prefixed with $) are replaced with values from the request body;\n- Default Values: Parameters not provided in the request body use their default values from the template definition;\n- Query Execution: The resulting query is executed against the Resource Registry;\n- Response Type: Can return complete instances or individual fields (when using _emit in the query);\n- Metadata Effect: includeMeta, allMeta, and includeContexts only affect queries returning complete instances, not _emit queries;\n- Polymorphic Behavior: When disabled (polymorphic=false), may impact query performance but ensures exact type matching;\n- No Pagination: Pagination is not currently supported for query template execution.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to execute query template;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to execute query template;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Context-Manager:**\n\t- Can execute query templates with hierarchical querying within their managed context hierarchy;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Can execute query templates in the current context only;\n\t- Cannot use hierarchical querying (hierarchical parameter ignored);\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n")
    @Parameters(value={@Parameter(name="polymorphic", in=ParameterIn.QUERY, description="Whether the query should consider instances polymorphically (include subtypes).\n- Default value: true (includes all subtypes);\n- Example: ?polymorphic=false (exact type match only, may slow down the query);\n- When false, only instances of the exact types defined in the query are returned;\n- When true, instances of derived types are also included.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="true", example="true")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response instances.\n- Default value: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Effect: Only applies when query returns complete instances of defined types;\n- No Effect: When query uses _emit to return individual fields instead of complete instances;\n- Restriction: IS-Manager and Infrastructure-Manager see complete metadata; other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="allMeta", in=ParameterIn.QUERY, description="Whether to include metadata for all nested instances (ConsistsOf relations, Facets, etc.).\n- Must be used in conjunction with includeMeta=true;\n- Default value: false (metadata only for main instances, more human-readable);\n- Example: ?includeMeta=true&allMeta=true (includes metadata for all nested elements);\n- Effect: Only applies when query returns complete instances of defined types;\n- No Effect: When query uses _emit to return individual fields instead of complete instances.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="hierarchical", in=ParameterIn.QUERY, description="Whether to execute the query across child contexts of the current context.\n- Default value: false (current context only);\n- Restriction: Only available to IS-Manager, Infrastructure-Manager, and Context-Manager roles (Context-Manager must be of the current context derived from the authorization token);\n- Example: ?hierarchical=true (executes query in current and child contexts);\n- Current context is determined from the authorization token.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="includeContexts", in=ParameterIn.QUERY, description="Whether to include the list of contexts where each returned instance is available.\n- Default value: false (context information not included);\n- Example: ?includeContexts=true (shows context availability for each instance);\n- Effect: Only applies when query returns complete instances of defined types;\n- No Effect: When query uses _emit to return individual fields instead of complete instances;\n- Note: A Resource is present in all contexts that form the union of contexts of all its Facets.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @RequestBody(description="JSON object containing parameter values for template substitution.\n- Parameters not provided in the body will use their default values from the template definition;\n- Parameter names must match those defined in the template's templateVariables section.\n\n\tExample Request Body:\n\t{\n\t\t\"$state\" : \"down\"\n\t}\n", required=false, content={@Content(mediaType="application/json")})
    @APIResponses(value={@APIResponse(responseCode="200", description="Query template successfully executed", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid query parameters or malformed parameter values"), @APIResponse(responseCode="404", description="Query template with the specified name does not exist"), @APIResponse(responseCode="403", description="Insufficient permissions to execute the query template")})
    public String runQueryTemplate(@PathParam(value="query-template-name") @Parameter(name="query-template-name", in=ParameterIn.PATH, description="The name of the query template to execute (e.g., \"GetAllEServiceWithState\")", required=true, schema=@Schema(type=SchemaType.STRING, example="GetAllEServiceWithState")) String queryTemplateName, String params) throws NotFoundException, InvalidQueryException, ResourceRegistryException {
        this.logger.info("Requested {} with name", (Object)"QueryTemplate", (Object)queryTemplateName);
        this.setAccountingMethod(Method.RUN, "QueryTemplate");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        QueryTemplateManagement queryTemplateManagement = new QueryTemplateManagement();
        queryTemplateManagement.setName(queryTemplateName);
        queryTemplateManagement.setParams(params);
        return queryTemplateManagement.run();
    }

    @GET
    @Path(value="instances/{type-name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="List Instances by specified Type", description="Retrieves all instances of a specified type from the Resource Registry.\nThe response can include metadata, hierarchical querying, and context information based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /access/instances/EService;\n- GET /access/instances/EService?limit=20&offset=40;\n- GET /access/instances/EService?polymorphic=true&includeMeta=true;\n- GET /access/instances/EService?includeMeta=true&allMeta=true;\n- GET /access/instances/EService?includeContexts=true;\n- GET /access/instances/EService?hierarchical=true;\n- GET /access/instances/EService?hierarchical=true&includeContexts=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to all metadata and hierarchical querying capabilities;\n\t- Can access instances across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to all metadata and hierarchical querying capabilities;\n\t- Can access instances across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Context-Manager:**\n\t- Full access to all metadata and hierarchical querying capabilities;\n\t- Must be Context-Manager of the current context derived from the authorization token;\n\t- Can access hierarchical querying capabilities;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Basic access with metadata filtering and no hierarchical querying;\n\t- Cannot use hierarchical querying (hierarchical parameter ignored);\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n")
    @Parameters(value={@Parameter(name="limit", in=ParameterIn.QUERY, description="Maximum number of instances to return in a single response.\n- Default value: 10;\n- Example: ?limit=50 (returns at most 50 instances).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="10", example="10")), @Parameter(name="offset", in=ParameterIn.QUERY, description="Number of instances to skip from the beginning of the result set.\n- Default value: 0 (starts from the first instance);\n- Example: ?offset=100 (skips the first 100 instances).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="0", example="0")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response instances.\n- Default value: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Metadata includes only the requested type and subtypes (if polymorphic=true);\n- Restriction: IS-Manager, Infrastructure-Manager, and Context-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="allMeta", in=ParameterIn.QUERY, description="Whether to include metadata for all nested instances (ConsistsOf relations, Facets, etc.).\n- Must be used in conjunction with includeMeta=true;\n- Default value: false (metadata only for main instances, more human-readable);\n- Example: ?includeMeta=true&allMeta=true (includes metadata for all nested elements);\n- Purpose: When false, produces more human-readable responses with less JSON to process.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="hierarchical", in=ParameterIn.QUERY, description="Whether to include instances from child contexts of the current context.\n- Default value: false (current context only);\n- Restriction: Only available to IS-Manager, Infrastructure-Manager, and Context-Manager roles (Context-Manager must be of the current context derived from the authorization token);\n- Example: ?hierarchical=true (includes instances from current and child contexts);\n- Current context is determined from the authorization token.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="includeContexts", in=ParameterIn.QUERY, description="Whether to include the list of contexts where each instance is available.\n- Default value: false (context information not included);\n- Example: ?includeContexts=true (shows context availability for each instance);\n- Note: A Resource is present in all contexts that form the union of contexts of all its Facets;\n- Note: ConsistsOf relations are present in all contexts where their target Facets are present.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Instances successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid query parameters (e.g., invalid limit/offset values)"), @APIResponse(responseCode="404", description="The specified type does not exist"), @APIResponse(responseCode="403", description="Insufficient permissions to access instances in the current context")})
    public String listInstances(@PathParam(value="type-name") @Parameter(name="type-name", in=ParameterIn.PATH, description="The name of the Information System type whose instances should be retrieved (e.g., 'EService', 'ContactFacet')", required=true, schema=@Schema(type=SchemaType.STRING, example="EService")) String type, @QueryParam(value="polymorphic") @DefaultValue(value="true") @Parameter(name="polymorphic", in=ParameterIn.QUERY, description="Whether to include instances of subtypes in the response.\n- Default value: true (includes all subtypes);\n- Example: ?polymorphic=false (returns only exact type instances).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="true", example="true")) Boolean polymorphic) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested all {}instances of {}", (Object)(polymorphic != false ? "polymorphic " : ""), (Object)type);
        this.setAccountingMethod(Method.LIST, "Instance");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        serverRequestInfo.checkLimitOffset();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        return erManagement.all(polymorphic.booleanValue());
    }

    @HEAD
    @Path(value="instances/{type-name}/{instance-uuid}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Check Instance Existence", description="Checks if an instance with the specified type and UUID exists in the Resource Registry.\nThe response status code indicates existence and accessibility based on context and user authorization.\n\n\n**Request Examples:**\n- HEAD /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f;\n- HEAD /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?hierarchical=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can check existence of any instance type in any context;\n\t- Can use hierarchical querying to check across context hierarchies;\n\t- Has full administrative access to existence checking.\n\n- **Infrastructure-Manager:**\n\t- Can check existence of any instance type in any context;\n\t- Can use hierarchical querying to check across context hierarchies;\n\t- Has full administrative access to existence checking.\n\n- **Context-Manager:**\n\t- Can check existence of instances in the current context;\n\t- Can use hierarchical querying within their managed context hierarchy;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Cannot check instances in contexts where they don't have Context-Manager role.\n\n- **Other Users:**\n\t- Can check existence of instances in the current context only;\n\t- Cannot use hierarchical querying (parameter is ignored);\n\t- Only within contexts where they have authorized access through their token.\n")
    @Parameter(name="hierarchical", in=ParameterIn.QUERY, description="Whether to check for instance existence in child contexts of the current context.\n- Default value: false (current context only);\n- Restriction: Only available to IS-Manager, Infrastructure-Manager, and Context-Manager roles (Context-Manager must be of the current context derived from the authorization token);\n- Example: ?hierarchical=true (checks current context and all child contexts);\n- Current context is determined from the authorization token.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))
    @APIResponses(value={@APIResponse(responseCode="204", description="Instance exists and is accessible in the current context"), @APIResponse(responseCode="404", description="Instance does not exist"), @APIResponse(responseCode="403", description="Instance exists but is available in another context (not accessible in current context)")})
    public Response existsInstance(@PathParam(value="type-name") @Parameter(name="type-name", in=ParameterIn.PATH, description="The name of the Information System type (e.g., 'EService', 'ContactFacet')", required=true, schema=@Schema(type=SchemaType.STRING, example="EService")) String type, @PathParam(value="instance-uuid") @Parameter(name="UUID", in=ParameterIn.PATH, description="The unique identifier of the instance to check", required=true, schema=@Schema(type=SchemaType.STRING, example="48af15ad-7e56-4157-b624-71c98cea4f8f")) String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to check if {} with id {} exists", (Object)type, (Object)uuid);
        this.setAccountingMethod(Method.EXIST, "Instance");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkBooleanQueryParameter("hierarchical");
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        try {
            erManagement.setUUID(UUID.fromString(uuid));
            boolean found = erManagement.exists();
            if (found) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (NotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AvailableInAnotherContextException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
    }

    @GET
    @Path(value="instances/{type-name}/{instance-uuid}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Read Instance by type and UUID", description="Retrieves a single instance with the specified type and UUID.\nThe response can include metadata, hierarchical querying, and context information based on query parameters and user authorization.\n\n\n**Request Examples:**\n- GET /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f;\n- GET /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeMeta=true;\n- GET /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeMeta=true&allMeta=true;\n- GET /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?includeContexts=true;\n- GET /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?hierarchical=true;\n- GET /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f?hierarchical=true&includeContexts=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to retrieve any instance in any context;\n\t- Can use hierarchical querying to search across context hierarchies;\n\t- Receive complete, unfiltered metadata for the instance and all nested elements;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Infrastructure-Manager:**\n\t- Full access to retrieve any instance in any context;\n\t- Can use hierarchical querying to search across context hierarchies;\n\t- Receive complete, unfiltered metadata for the instance and all nested elements;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Context-Manager:**\n\t- Can retrieve instances in the current context and child contexts;\n\t- Can use hierarchical querying within their managed context hierarchy;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Receive complete, unfiltered metadata for the instance and all nested elements;\n\t- Metadata includes all administrative fields without obfuscation.\n\n- **Other Users:**\n\t- Can retrieve instances in the current context only;\n\t- Cannot use hierarchical querying (hierarchical parameter ignored);\n\t- Receive metadata with sensitive information filtered when includeMeta=true:\n\t\t- Date fields (creation, modification) are visible;\n\t\t- User identifiers (createdBy, lastUpdateBy) are obfuscated or hidden;\n\t\t- Other administrative details may be filtered.\n")
    @Parameters(value={@Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response instance.\n- Default value: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Metadata includes the requested instance and nested elements based on polymorphic setting;\n- Restriction: IS-Manager, Infrastructure-Manager, and Context-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="allMeta", in=ParameterIn.QUERY, description="Whether to include metadata for all nested instances (ConsistsOf relations, Facets, etc.).\n- Must be used in conjunction with includeMeta=true;\n- Default value: false (metadata only for main instance, more human-readable);\n- Example: ?includeMeta=true&allMeta=true (includes metadata for all nested elements);\n- Purpose: When false, produces more human-readable responses with less JSON to process.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="hierarchical", in=ParameterIn.QUERY, description="Whether to retrieve the instance from child contexts of the current context.\n- Default value: false (current context only);\n- Restriction: Only available to IS-Manager, Infrastructure-Manager, and Context-Manager roles (Context-Manager must be of the current context derived from the authorization token);\n- Example: ?hierarchical=true (searches current and child contexts for the instance);\n- Current context is determined from the authorization token.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="includeContexts", in=ParameterIn.QUERY, description="Whether to include the list of contexts where the instance and its nested elements are available.\n- Default value: false (context information not included);\n- Example: ?includeContexts=true (shows context availability for the instance and nested elements);\n- Note: A Resource is present in all contexts that form the union of contexts of all its Facets;\n- Note: ConsistsOf relations are present in all contexts where their target Facets are present.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Instance successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Instance does not exist"), @APIResponse(responseCode="403", description="Instance exists but is available in another context (not accessible in current context)")})
    public String readInstance(@PathParam(value="type-name") @Parameter(name="type-name", in=ParameterIn.PATH, description="The name of the Information System type (e.g., 'EService', 'ContactFacet')", required=true, schema=@Schema(type=SchemaType.STRING, example="EService")) String type, @PathParam(value="instance-uuid") @Parameter(name="instance-uuid", in=ParameterIn.PATH, description="The unique identifier of the instance to retrieve", required=true, schema=@Schema(type=SchemaType.STRING, example="48af15ad-7e56-4157-b624-71c98cea4f8f")) String uuid) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to read {} with id {}", (Object)type, (Object)uuid);
        this.setAccountingMethod(Method.READ, "Instance");
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setElementType(type);
        erManagement.setUUID(UUID.fromString(uuid));
        return erManagement.read().toString();
    }

    @GET
    @Path(value="instances/{type-name}/{instance-uuid}/contexts")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Get Contexts for Instance", description="Retrieves the list of contexts where a specific instance is present in the Resource Registry.\nThis endpoint does not accept any query parameters.\n\n\n**Request Examples:**\n- GET /access/instances/EService/48af15ad-7e56-4157-b624-71c98cea4f8f/contexts;\n- GET /access/instances/ContactFacet/4023d5b2-8601-47a5-83ef-49ffcbfc7d86/contexts.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Can retrieve context information for any instance;\n\t- Full access to view contexts across the entire infrastructure.\n\n- **Infrastructure-Manager:**\n\t- Can retrieve context information for any instance;\n\t- Full access to view contexts across the entire infrastructure.\n\n- **Context-Manager:**\n\t- Can retrieve context information for any accessible instance;\n\t- Access depends on their Context-Manager role in relevant contexts.\n\n- **Other Users:**\n\t- Can retrieve context information for any accessible instance;\n\t- Access depends on their permissions and context availability through their token.\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="Context list successfully retrieved", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="404", description="Instance does not exist"), @APIResponse(responseCode="403", description="Instance exists but is available in another context (not accessible for context listing)")})
    public String getInstanceContexts(@PathParam(value="type-name") @Parameter(name="type-name", in=ParameterIn.PATH, description="The name of the Information System type (e.g., 'EService', 'ContactFacet')", required=true, schema=@Schema(type=SchemaType.STRING, example="EService")) String type, @PathParam(value="instance-uuid") @Parameter(name="instance-uuid", in=ParameterIn.PATH, description="The unique identifier of the instance whose contexts to retrieve", required=true, schema=@Schema(type=SchemaType.STRING, example="48af15ad-7e56-4157-b624-71c98cea4f8f")) String instanceId) throws NotFoundException, ResourceRegistryException {
        this.logger.info("Requested to get contexts of {} with UUID {}", (Object)type, (Object)instanceId);
        this.setAccountingMethod("getInstanceContexts");
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)type);
        erManagement.setUUID(UUID.fromString(instanceId));
        return erManagement.getContexts();
    }

    @GET
    @Path(value="query")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Execute Graph Query (OrientDB SQL)", description="Executes a graph query directly against the Resource Registry backend database using OrientDB SQL syntax.\n\nThis endpoint is intended for development, debugging, and administrative purposes only. Not for production use.\n\n\n\u26a0\ufe0f **PRODUCTION WARNING**:\n- \u26a0\ufe0f **NOT FOR PRODUCTION USE**: This endpoint is intended for development, debugging, and administrative purposes only;\n- \u26a0\ufe0f **NO COMPATIBILITY GUARANTEE**: The query syntax and behavior may change without notice;\n- \u26a0\ufe0f **BACKEND DEPENDENCY**: Currently based on OrientDB which may be replaced at any time without prior warning;\n- \u26a0\ufe0f **BREAKING CHANGES**: Future backend changes will break existing queries without migration support;\n- \u26a0\ufe0f **USE AT YOUR OWN RISK**: Production applications should use type-specific endpoints instead.\n\n\n**Request Examples:**\n- GET /access/query?q=SELECT FROM V;\n- GET /access/query?q=SELECT count(*) FROM Resource;\n- GET /access/query?q=SELECT FROM EService&raw=true;\n- GET /access/query?q=SELECT FROM EService SKIP 10 LIMIT 20;\n- GET /access/query?q=SELECT FROM EService WHERE out('ConsistsOf').@class = 'StateFacet';\n- GET /access/query?q=SELECT FROM EService&includeMeta=true;\n- GET /access/query?q=SELECT FROM EService&hierarchical=true.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to execute any graph query;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata when raw=false and includeMeta=true;\n\t- Can access raw backend responses when raw=true.\n\n- **Infrastructure-Manager:**\n\t- Full access to execute any graph query;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata when raw=false and includeMeta=true;\n\t- Can access raw backend responses when raw=true.\n")
    @Parameters(value={@Parameter(name="polymorphic", in=ParameterIn.QUERY, description="Whether to include instances of subtypes both main type instance as well as nested instances.\n- Default value: true (includes all subtypes both main type instance as well as nested instances);\n- Only effective when raw=false (ignored when raw=true);\n- Example: ?polymorphic=false (exact type matching both main type instance as well as nested instances).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="true", example="true")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response instances.\n- Default value: false (basic information only);\n- Only effective when raw=false (ignored when raw=true);\n- Example: ?includeMeta=true (includes complete metadata for admin users).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="allMeta", in=ParameterIn.QUERY, description="Whether to include metadata for all nested instances (ConsistsOf relations, Facets, etc.).\n- Must be used in conjunction with includeMeta=true;\n- Default value: false (metadata only for main instances);\n- Only effective when raw=false (ignored when raw=true);\n- Example: ?includeMeta=true&allMeta=true (includes metadata for all nested elements).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="hierarchical", in=ParameterIn.QUERY, description="Whether to execute the query across child contexts of the current context.\n- Default value: false (current context only);\n- Restriction: Only available to IS-Manager and Infrastructure-Manager roles;\n- Example: ?hierarchical=true (executes query in current and child contexts);\n- When raw=true: Only this parameter is checked (other boolean parameters ignored);\n- When raw=false: All boolean parameters are validated and applied.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="includeContexts", in=ParameterIn.QUERY, description="Whether to include the list of contexts where each returned instance is available.\n- Default value: false (context information not included);\n- Only effective when raw=false (ignored when raw=true);\n- Example: ?includeContexts=true (shows context availability for each instance).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Query successfully executed", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid query syntax or non-idempotent query attempted"), @APIResponse(responseCode="403", description="Insufficient permissions to execute graph queries (only IS-Manager and Infrastructure-Manager allowed)")})
    public String graphQuery(@QueryParam(value="q") @Parameter(name="q", in=ParameterIn.QUERY, description="The OrientDB SQL query to execute against the backend.\n- Must be URL-encoded for special characters;\n- Only idempotent queries are accepted (SELECT statements);\n- For query syntax reference: https://orientdb.com/docs/last/SQL-Syntax.html;\n- Example: SELECT FROM EService WHERE out('ConsistsOf').@class = 'StateFacet'.\n", required=true, schema=@Schema(type=SchemaType.STRING, example="SELECT FROM EService WHERE out('ConsistsOf').@class = 'StateFacet'")) String query, @QueryParam(value="raw") @DefaultValue(value="false") @Parameter(name="raw", in=ParameterIn.QUERY, description="Whether to return the raw backend response or format it according to the Information System model.\n- Default value: false (format results according to IS model);\n- When false: Results are converted to standard Information System model format with proper typing and structure;\n- When true: Results are returned exactly as provided by the OrientDB backend without any formatting or conversion;\n- Example: ?raw=true (returns raw OrientDB response format).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="true")) Boolean raw) throws InvalidQueryException {
        this.logger.info("Requested query (Raw {}):\n{}", (Object)raw, (Object)query);
        if (raw.booleanValue()) {
            this.setAccountingMethod(Method.QUERY, RAW_QUERY_METHOD);
        } else {
            this.setAccountingMethod(Method.QUERY, GRAPH_QUERY_METHOD);
        }
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        if (raw.booleanValue()) {
            serverRequestInfo.checkBooleanQueryParameter("hierarchical");
        } else {
            serverRequestInfo.checkAllBooleanQueryParameters();
        }
        QueryImpl queryManager = new QueryImpl();
        return queryManager.query(query, raw.booleanValue());
    }

    @POST
    @Path(value="query")
    @Operation(summary="Execute JSON Query", description="Executes a JSON-based query to find instances matching the specified structure in the Resource Registry.\n\nThe response can include metadata, hierarchical querying, and context information based on query parameters and user authorization.\n\n\n**Request Examples:**\n- POST /access/query;\n- POST /access/query?limit=20&offset=40;\n- POST /access/query?polymorphic=true&includeMeta=true;\n- POST /access/query?includeMeta=true&allMeta=true;\n- POST /access/query?includeContexts=true;\n- POST /access/query?hierarchical=true;\n- POST /access/query?hierarchical=true&includeContexts=true.\n\n\n**Operation Behavior:**\n- Structure Matching: The JSON query describes the structure to match - instances must have the specified properties and relations;\n- Flexible Matching: Properties not specified in the query are ignored; only specified properties must match;\n- Relation Traversal: ConsistsOf and IsRelatedTo relations are traversed to find matching nested structures;\n- Type Polymorphism: When polymorphic=true, subtypes are included in both main results and nested relations;\n- Pagination Support: Results can be paginated using limit and offset parameters;\n- Context Scope: Queries execute within the current context unless hierarchical=true is specified by authorized users.\n\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to execute any JSON query;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to execute any JSON query;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Context-Manager:**\n\t- Can execute JSON queries with hierarchical querying within their managed context hierarchy;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Can execute JSON queries in the current context only;\n\t- Cannot use hierarchical querying (hierarchical parameter ignored);\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n")
    @RequestBody(description="JSON object describing the structure to search for.\n- Must specify the target type and optionally its relations and properties;\n- Relations can include ConsistsOf, IsRelatedTo, and other defined relation types;\n- Properties can specify exact values or patterns to match.\n", required=true, content={@Content(mediaType="application/json", examples={@ExampleObject(name="Find EService with specific state and software", value="\t{\n\t\t\"type\": \"EService\",\n\t\t\"consistsOf\": [\n\t\t\t{\n\t\t\t\t\"type\": \"ConsistsOf\",\n\t\t\t\t\"propagationConstraint\": {\n\t\t\t\t\t\"add\": \"propagate\"\n\t\t\t\t},\n\t\t\t\t\"target\": {\n\t\t\t\t\t\"type\": \"StateFacet\",\n\t\t\t\t\t\"value\": \"down\"\n\t\t\t\t}\n\t\t\t},\n\t\t\t{\n\t\t\t\t\"type\": \"IsIdentifiedBy\",\n\t\t\t\t\"target\": {\n\t\t\t\t\t\"type\": \"SoftwareFacet\",\n\t\t\t\t\t\"name\": \"data-transfer-service\",\n\t\t\t\t\t\"group\": \"DataTransfer\"\n\t\t\t\t}\n\t\t\t}\n\t\t]\n\t}\n")})})
    @Parameters(value={@Parameter(name="polymorphic", in=ParameterIn.QUERY, description="Whether to include instances of subtypes in the response and nested instances.\n- Default value: true (includes all subtypes);\n- Example: ?polymorphic=false (returns only exact type instances).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="true", example="true")), @Parameter(name="limit", in=ParameterIn.QUERY, description="Maximum number of instances to return in a single response.\n- Default value: 10;\n- Example: ?limit=50 (returns at most 50 instances).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="10", example="10")), @Parameter(name="offset", in=ParameterIn.QUERY, description="Number of instances to skip from the beginning of the result set.\n- Default value: 0 (starts from the first instance);\n- Example: ?offset=100 (skips the first 100 instances).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="0", example="0")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response instances.\n- Default value: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Metadata includes only the requested type and subtypes (if polymorphic=true);\n- Restriction: IS-Manager, Infrastructure-Manager, and Context-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="allMeta", in=ParameterIn.QUERY, description="Whether to include metadata for all nested instances (ConsistsOf relations, Facets, etc.).\n- Must be used in conjunction with includeMeta=true;\n- Default value: false (metadata only for main instances, more human-readable);\n- Example: ?includeMeta=true&allMeta=true (includes metadata for all nested elements);\n- Purpose: When false, produces more human-readable responses with less JSON to process.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="hierarchical", in=ParameterIn.QUERY, description="Whether to include instances from child contexts of the current context.\n- Default value: false (current context only);\n- Restriction: Only available to IS-Manager, Infrastructure-Manager, and Context-Manager roles (Context-Manager must be of the current context derived from the authorization token);\n- Example: ?hierarchical=true (includes instances from current and child contexts);\n- Current context is determined from the authorization token.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="includeContexts", in=ParameterIn.QUERY, description="Whether to include the list of contexts where each instance is available.\n- Default value: false (context information not included);\n- Example: ?includeContexts=true (shows context availability for each instance);\n- Note: A Resource is present in all contexts that form the union of contexts of all its Facets;\n- Note: ConsistsOf relations are present in all contexts where their target Facets are present.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="JSON query successfully executed", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid query structure, syntax errors, or invalid parameters"), @APIResponse(responseCode="403", description="Insufficient permissions to execute JSON queries or access hierarchical data")})
    public String jsonQuery(String jsonQuery) throws InvalidQueryException, ResourceRegistryException {
        this.logger.info("Requested json query \n{}", (Object)jsonQuery);
        this.setAccountingMethod(Method.QUERY, JSON_QUERY_METHOD);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        serverRequestInfo.checkLimitOffset();
        JsonQuery jsonQueryManager = new JsonQuery();
        jsonQueryManager.setJsonQuery(jsonQuery);
        return jsonQueryManager.query();
    }

    @GET
    @Path(value="query/{resource-type-name}/{relation-type-name}/{reference-type-name}")
    @Produces(value={"application/json;charset=UTF-8"})
    @Operation(summary="Execute Prepared Query (Resource-Relation-Entity)", description="Executes a prepared query to find resources connected to specific entities through defined relations.\n\nThis method provides a structured way to query the Resource Registry using path and query parameters.\n\n\n**Request Examples:**\n- GET /access/query/EService/IsIdentifiedBy/SoftwareFacet?_polymorphic=true&_direction=out;\n- GET /access/query/EService/IsIdentifiedBy/SoftwareFacet?_reference=7bc997c3-d005-40ff-b9ed-c4b6a35851f1&_polymorphic=true&_direction=out;\n- GET /access/query/Resource/ConsistsOf/ContactFacet?_polymorphic=true&_direction=out;\n- GET /access/query/EService/Hosts/HostingNode?_polymorphic=true&_direction=in;\n- GET /access/query/EService/Hosts/HostingNode?_reference=16032d09-3823-444e-a1ff-a67de4f350a8&_polymorphic=true&_direction=in;\n- GET /access/query/EService/IsIdentifiedBy/SoftwareFacet?_polymorphic=true&_direction=out&limit=20&offset=40;\n- GET /access/query/EService/IsIdentifiedBy/SoftwareFacet?_polymorphic=true&_direction=out&includeMeta=true;\n- GET /access/query/EService/IsIdentifiedBy/SoftwareFacet?_polymorphic=true&_direction=out&hierarchical=true.\n\n\n**Operation Behavior:**\n- Prepared Query Pattern: Uses path parameters to define the query structure (resource-relation-entity pattern);\n- Relation Traversal: Follows the specified relation in the given direction to find connected resources;\n- Constraint Application: Additional query parameters are applied as property filters on the target entities;\n- Type Validation: Resource type must be a valid Resource type; relation and entity types must exist in the model;\n- Reference Filtering: When _reference is specified, only resources connected to that specific entity instance are returned;\n- Pagination Support: Results can be paginated using limit and offset parameters;\n- Context Scope: Queries execute within the current context unless hierarchical=true is specified by authorized users.\n\n**Authorization Requirements:**\n- **IS-Manager:**\n\t- Full access to execute any prepared query;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Infrastructure-Manager:**\n\t- Full access to execute any prepared query;\n\t- Can use hierarchical querying across all contexts;\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Context-Manager:**\n\t- Can execute prepared queries with hierarchical querying within their managed context hierarchy;\n\t- Must be Context-Manager of the current context (derived from the authorization token);\n\t- Receives complete, unfiltered metadata including all administrative fields.\n\n- **Other Users:**\n\t- Can execute prepared queries in the current context only;\n\t- Cannot use hierarchical querying (hierarchical parameter ignored);\n\t- Receive metadata with sensitive information filtered when includeMeta=true.\n")
    @Parameters(value={@Parameter(name="limit", in=ParameterIn.QUERY, description="Maximum number of instances to return in a single response.\n- Default value: 10;\n- Example: ?limit=50 (returns at most 50 instances).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="10", example="10")), @Parameter(name="offset", in=ParameterIn.QUERY, description="Number of instances to skip from the beginning of the result set.\n- Default value: 0 (starts from the first instance);\n- Example: ?offset=100 (skips the first 100 instances).\n", required=false, schema=@Schema(type=SchemaType.INTEGER, defaultValue="0", example="0")), @Parameter(name="includeMeta", in=ParameterIn.QUERY, description="Whether to include metadata in the response instances.\n- Default value: false (basic information only);\n- Example: ?includeMeta=true (includes metadata with appropriate filtering based on user role);\n- Metadata includes only the requested type and subtypes (if polymorphic=true);\n- Restriction: IS-Manager, Infrastructure-Manager, and Context-Manager see complete metadata including sensitive information (createdBy, lastUpdatedBy); other users see filtered metadata with sensitive fields obfuscated.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="allMeta", in=ParameterIn.QUERY, description="Whether to include metadata for all nested instances (ConsistsOf relations, Facets, etc.).\n- Must be used in conjunction with includeMeta=true;\n- Default value: false (metadata only for main instances, more human-readable);\n- Example: ?includeMeta=true&allMeta=true (includes metadata for all nested elements);\n- Purpose: When false, produces more human-readable responses with less JSON to process.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="hierarchical", in=ParameterIn.QUERY, description="Whether to include instances from child contexts of the current context.\n- Default value: false (current context only);\n- Restriction: Only available to IS-Manager, Infrastructure-Manager, and Context-Manager roles (Context-Manager must be of the current context derived from the authorization token);\n- Example: ?hierarchical=true (includes instances from current and child contexts);\n- Current context is determined from the authorization token.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")), @Parameter(name="includeContexts", in=ParameterIn.QUERY, description="Whether to include the list of contexts where each instance is available.\n- Default value: false (context information not included);\n- Example: ?includeContexts=true (shows context availability for each instance);\n- Note: A Resource is present in all contexts that form the union of contexts of all its Facets;\n- Note: ConsistsOf relations are present in all contexts where their target Facets are present.\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false"))})
    @APIResponses(value={@APIResponse(responseCode="200", description="Prepared query successfully executed", content={@Content(mediaType="application/json")}), @APIResponse(responseCode="400", description="Invalid resource type, relation type, entity type, UUID format, or query parameters"), @APIResponse(responseCode="403", description="Insufficient permissions to execute prepared queries or access hierarchical data"), @APIResponse(responseCode="404", description="Specified types do not exist in the model")})
    public String getAllResourcesHavingFacet(@PathParam(value="resource-type-name") @Parameter(name="resource-type-name", in=ParameterIn.PATH, description="The name of the Resource type to search for (e.g., 'EService', 'HostingNode', 'Software')", required=true, schema=@Schema(type=SchemaType.STRING, example="EService")) String resourceTypeName, @PathParam(value="relation-type-name") @Parameter(name="relation-type-name", in=ParameterIn.PATH, description="The name of the relation connecting resources to entities (e.g., 'IsIdentifiedBy', 'ConsistsOf', 'Hosts')", required=true, schema=@Schema(type=SchemaType.STRING, example="IsIdentifiedBy")) String relationTypeName, @PathParam(value="reference-type-name") @Parameter(name="reference-type-name", in=ParameterIn.PATH, description="The name of the Resource/Facet type connected through the relation (e.g., 'SoftwareFacet', 'ContactFacet', 'EService', 'HostingNode')", required=true, schema=@Schema(type=SchemaType.STRING, example="SoftwareFacet")) String referenceTypeName, @QueryParam(value="_reference") @Parameter(name="_reference", in=ParameterIn.QUERY, description="- UUID of a specific entity instance to filter by;\n- When specified: only resources connected to that specific entity instance are returned;\n- When not specified: resources connected to any entity of the specified type are returned;\n- Must be a valid UUID format;\n- Example: ?_reference=7bc997c3-d005-40ff-b9ed-c4b6a35851f1.\n", required=false, schema=@Schema(type=SchemaType.STRING, example="7bc997c3-d005-40ff-b9ed-c4b6a35851f1")) String reference, @QueryParam(value="_polymorphic") @DefaultValue(value="false") @Parameter(name="_polymorphic", in=ParameterIn.QUERY, description="Whether to include instances of subtypes in the response and nested relations.\n- Default value: false (exact type matching only);\n- Example: ?_polymorphic=true (includes all subtypes).\n", required=false, schema=@Schema(type=SchemaType.BOOLEAN, defaultValue="false", example="false")) Boolean polymorphic, @QueryParam(value="_direction") @DefaultValue(value="out") @Parameter(name="_direction", in=ParameterIn.QUERY, description="- Direction of the relation traversal from the resource perspective;\n- Default value: out (outgoing relations from resource);\n- Values: out|in;\n- out: Resources having outgoing relations to the specified entity type (e.g., Resource ConsistsOf Facet);\n- in: Resources having incoming relations from the specified entity type (e.g., EService hosted by HostingNode);\n- Example: ?_direction=in (incoming relations).\n", required=false, schema=@Schema(type=SchemaType.STRING, defaultValue="out", example="in")) String direction, @Context UriInfo uriInfo) throws ResourceRegistryException {
        this.logger.info("Requested {} instances having a(n) {} ({}={}} with {} ({}={}). Request URI is {})", new Object[]{resourceTypeName, relationTypeName, "_direction", direction, referenceTypeName, "_polymorphic", polymorphic, uriInfo.getRequestUri()});
        this.setAccountingMethod(Method.QUERY, PREPARED_QUERY_METHOD);
        ServerRequestInfo serverRequestInfo = this.initRequestInfo();
        serverRequestInfo.checkAllBooleanQueryParameters();
        serverRequestInfo.checkLimitOffset();
        ElementManagement erManagement = ERManagementUtility.getERManagement((String)resourceTypeName);
        if (erManagement instanceof ResourceManagement) {
            String error;
            ResourceManagement management = (ResourceManagement)erManagement;
            UUID refereceUUID = null;
            ODirection directionEnum = ODirection.OUT;
            HashMap<String, String> constraint = new HashMap<String, String>();
            MultivaluedMap multivaluedMap = uriInfo.getQueryParameters();
            Iterator iterator = multivaluedMap.keySet().iterator();
            block18: while (iterator.hasNext()) {
                String key;
                switch (key = (String)iterator.next()) {
                    case "_polymorphic": {
                        continue block18;
                    }
                    case "_direction": {
                        continue block18;
                    }
                    case "_reference": {
                        continue block18;
                    }
                    case "gcube-token": {
                        continue block18;
                    }
                    case "gcube-scope": {
                        continue block18;
                    }
                }
                constraint.put(key, (String)multivaluedMap.getFirst((Object)key));
            }
            if (reference != null) {
                try {
                    refereceUUID = UUID.fromString(reference);
                }
                catch (Exception e) {
                    error = "%s is not a valid %s".formatted(reference, UUID.class.getSimpleName());
                    throw new InvalidQueryException(error);
                }
            }
            try {
                directionEnum = ODirection.valueOf((String)direction.toUpperCase());
            }
            catch (Exception e) {
                error = "%s is not a valid. Allowed values are %s".formatted(direction, ODirection.values());
                throw new InvalidQueryException(error);
            }
            return management.query(relationTypeName, referenceTypeName, refereceUUID, directionEnum, polymorphic.booleanValue(), constraint);
        }
        String error = "%s is not a %s type".formatted(resourceTypeName, "Resource");
        throw new InvalidQueryException(error);
    }
}

