/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.environments;

import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.security.Owner;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.contexts.ContextUtility;
import org.gcube.informationsystem.resourceregistry.dbinitialization.DatabaseEnvironment;
import org.gcube.informationsystem.resourceregistry.environments.Environment;
import org.gcube.informationsystem.resourceregistry.environments.administration.AdminEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Environment {
    private static Logger logger = LoggerFactory.getLogger(Environment.class);
    protected static final String DEFAULT_WRITER_ROLE = "writer";
    protected static final String DEFAULT_READER_ROLE = "reader";
    protected final UUID environmentUUID;
    protected final Map<PermissionMode, ODatabasePool> poolMap;
    protected static Set<String> allOperationAllowedRoles = new HashSet();
    protected Set<String> allowedRoles;
    public static final String INFRASTRUCTURE_MANAGER = "Infrastructure-Manager";
    public static final String IS_MANAGER = "IS-Manager";
    public static final String CONTEXT_MANAGER = "Context-Manager";

    public static Set<String> getAllOperationsAllowedRoles() {
        return new HashSet<String>(allOperationAllowedRoles);
    }

    public Set<String> getAllowedRoles() {
        return new HashSet<String>(this.allowedRoles);
    }

    protected Environment(UUID context) throws ResourceRegistryException {
        this.environmentUUID = context;
        this.poolMap = new HashMap();
        this.allowedRoles = new HashSet(allOperationAllowedRoles);
        this.allowedRoles.add("Context-Manager");
    }

    protected synchronized ODatabasePool getPool(PermissionMode permissionMode, boolean recreate) {
        ODatabasePool pool = null;
        if (recreate && (pool = (ODatabasePool)this.poolMap.get(permissionMode)) != null) {
            pool.close();
            this.poolMap.remove(permissionMode);
        }
        if ((pool = (ODatabasePool)this.poolMap.get(permissionMode)) == null) {
            String username = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER);
            String password = (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode);
            pool = new ODatabasePool(DatabaseEnvironment.DB_URI, username, password);
            this.poolMap.put(permissionMode, pool);
        }
        return pool;
    }

    public UUID getUUID() {
        return this.environmentUUID;
    }

    public static String getRoleOrUserName(PermissionMode permissionMode, SecurityType securityType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(permissionMode);
        stringBuilder.append(securityType);
        return stringBuilder.toString();
    }

    public String getSecurityRoleOrUserName(PermissionMode permissionMode, SecurityType securityType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Environment.getRoleOrUserName((PermissionMode)permissionMode, (SecurityType)securityType));
        stringBuilder.append("_");
        stringBuilder.append(this.environmentUUID.toString());
        return stringBuilder.toString();
    }

    private OSecurity getOSecurity(ODatabaseDocument oDatabaseDocument) {
        return oDatabaseDocument.getMetadata().getSecurity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElement(OElement element) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument adminDatabaseDocument = null;
        try {
            adminDatabaseDocument = AdminEnvironment.getInstance().getDatabaseDocument(PermissionMode.WRITER);
            this.addElement(element, adminDatabaseDocument);
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected void allow(OSecurity oSecurity, ODocument oDocument) {
        String writerRoleName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.ROLE);
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_ALL, writerRoleName);
        String readerRoleName = this.getSecurityRoleOrUserName(PermissionMode.READER, SecurityType.ROLE);
        oSecurity.allowRole(oDocument, ORestrictedOperation.ALLOW_READ, readerRoleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isElementInContext(OElement element) throws ResourceRegistryException {
        ORID orid = element.getIdentity();
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument contextODatabaseDocument = null;
        try {
            contextODatabaseDocument = this.getDatabaseDocument(PermissionMode.READER);
            ORecord oRecord = contextODatabaseDocument.getRecord((OIdentifiable)orid);
            if (oRecord == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (contextODatabaseDocument != null) {
                contextODatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public void addElement(OElement element, ODatabaseDocument oDatabaseDocument) {
        ODocument oDocument = (ODocument)element.getRecord();
        OSecurity oSecurity = this.getOSecurity(oDatabaseDocument);
        this.allow(oSecurity, oDocument);
        oDocument.save();
        element.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeElement(OElement element) throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument adminDatabaseDocument = null;
        try {
            adminDatabaseDocument = AdminEnvironment.getInstance().getDatabaseDocument(PermissionMode.WRITER);
            this.removeElement(element, adminDatabaseDocument);
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected void deny(OSecurity oSecurity, ODocument oDocument) {
        String writerUserName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.USER);
        oSecurity.denyUser(oDocument, ORestrictedOperation.ALLOW_ALL, writerUserName);
        String readerUserName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.USER);
        oSecurity.denyUser(oDocument, ORestrictedOperation.ALLOW_READ, readerUserName);
        String writerRoleName = this.getSecurityRoleOrUserName(PermissionMode.WRITER, SecurityType.ROLE);
        oSecurity.denyRole(oDocument, ORestrictedOperation.ALLOW_ALL, writerRoleName);
        String readerRoleName = this.getSecurityRoleOrUserName(PermissionMode.READER, SecurityType.ROLE);
        oSecurity.denyRole(oDocument, ORestrictedOperation.ALLOW_READ, readerRoleName);
    }

    public void removeElement(OElement element, ODatabaseDocument oDatabaseDocument) {
        ODocument oDocument = (ODocument)element.getRecord();
        OSecurity oSecurity = this.getOSecurity(oDatabaseDocument);
        this.deny(oSecurity, oDocument);
        oDocument.save();
        element.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean allowed(ORole role, ODocument oDocument) {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument oDatabaseDocument = null;
        try {
            oDatabaseDocument = this.getDatabaseDocument(PermissionMode.READER);
            oDatabaseDocument.activateOnCurrentThread();
            ORecord element = oDatabaseDocument.getRecord((OIdentifiable)oDocument.getIdentity());
            if (element == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (oDatabaseDocument != null) {
                oDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    public boolean isUserAllowed(Collection<String> allowedRoles) {
        boolean allowed = false;
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        HashSet roles = new HashSet(owner.getRoles());
        roles.addAll(owner.getGlobalRoles());
        roles.retainAll(allowedRoles);
        if (roles.size() > 0) {
            allowed = true;
        }
        return allowed;
    }

    public void create() throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument adminDatabaseDocument = null;
        try {
            adminDatabaseDocument = AdminEnvironment.getInstance().getDatabaseDocument(PermissionMode.WRITER);
            this.create(adminDatabaseDocument);
            adminDatabaseDocument.commit();
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected ORole addExtraRules(ORole role, PermissionMode permissionMode) {
        return role;
    }

    protected ORole getSuperRole(OSecurity oSecurity, PermissionMode permissionMode) {
        String superRoleName = permissionMode.name().toLowerCase();
        return oSecurity.getRole(superRoleName);
    }

    protected void createRolesAndUsers(OSecurity oSecurity) {
        for (PermissionMode permissionMode : PermissionMode.values()) {
            ORole superRole = this.getSuperRole(oSecurity, permissionMode);
            String roleName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.ROLE);
            ORole role = oSecurity.createRole(roleName, superRole, OSecurityRole.ALLOW_MODES.DENY_ALL_BUT);
            this.addExtraRules(role, permissionMode);
            role.save();
            logger.trace("{} created", (Object)role);
            String userName = this.getSecurityRoleOrUserName(permissionMode, SecurityType.USER);
            OUser user = oSecurity.createUser(userName, (String)DatabaseEnvironment.DEFAULT_PASSWORDS.get(permissionMode), new ORole[]{role});
            user.save();
            logger.trace("{} created", (Object)user);
        }
    }

    public void create(ODatabaseDocument oDatabaseDocument) {
        OSecurity oSecurity = this.getOSecurity(oDatabaseDocument);
        this.createRolesAndUsers(oSecurity);
        logger.trace("Security Context (roles and users) with UUID {} successfully created", (Object)this.environmentUUID.toString());
    }

    protected void drop(OSecurity oSecurity, String name, SecurityType securityType) {
        boolean dropped = false;
        switch (1.$SwitchMap$org$gcube$informationsystem$resourceregistry$environments$Environment$SecurityType[securityType.ordinal()]) {
            case 1: {
                dropped = oSecurity.dropRole(name);
                break;
            }
            case 2: {
                dropped = oSecurity.dropUser(name);
                break;
            }
        }
        if (dropped) {
            logger.trace("{} successfully dropped", (Object)name);
        } else {
            logger.error("{} was not dropped successfully", (Object)name);
        }
    }

    public void delete() throws ResourceRegistryException {
        ODatabaseDocument current = ContextUtility.getCurrentODatabaseDocumentFromThreadLocal();
        ODatabaseDocument adminDatabaseDocument = null;
        try {
            adminDatabaseDocument = AdminEnvironment.getInstance().getDatabaseDocument(PermissionMode.WRITER);
            this.delete(adminDatabaseDocument);
            adminDatabaseDocument.commit();
        }
        finally {
            if (adminDatabaseDocument != null) {
                adminDatabaseDocument.close();
            }
            if (current != null) {
                current.activateOnCurrentThread();
            }
        }
    }

    protected void deleteRolesAndUsers(OSecurity oSecurity) {
        for (PermissionMode permissionMode : PermissionMode.values()) {
            for (SecurityType securityType : SecurityType.values()) {
                String name = this.getSecurityRoleOrUserName(permissionMode, securityType);
                this.drop(oSecurity, name, securityType);
            }
        }
    }

    public void delete(ODatabaseDocument orientGraph) {
        OSecurity oSecurity = this.getOSecurity(orientGraph);
        this.delete(oSecurity);
    }

    private void delete(OSecurity oSecurity) {
        logger.trace("Going to remove Security Context (roles and users) with UUID {}", (Object)this.environmentUUID.toString());
        this.deleteRolesAndUsers(oSecurity);
        logger.trace("Security Context (roles and users) with UUID {} successfully removed", (Object)this.environmentUUID.toString());
    }

    public ODatabaseDocument getDatabaseDocument(PermissionMode permissionMode) throws ResourceRegistryException {
        try {
            ODatabasePool oDatabasePool = this.getPool(permissionMode, false);
            ODatabaseSession oDatabaseSession = null;
            try {
                oDatabaseSession = oDatabasePool.acquire();
                if (oDatabaseSession.isClosed()) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                oDatabasePool = this.getPool(permissionMode, true);
                oDatabaseSession = oDatabasePool.acquire();
            }
            oDatabaseSession.activateOnCurrentThread();
            return oDatabaseSession;
        }
        catch (Exception e) {
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    public String toString() {
        return "%s %s".formatted(this.getClass().getSimpleName(), this.getUUID().toString());
    }

    static {
        allOperationAllowedRoles.add("Infrastructure-Manager");
        allOperationAllowedRoles.add("IS-Manager");
    }
}

