package org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.RelationAlreadyPresentException;

/**
 * The Class IsRelatedToAlreadyPresentException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class IsRelatedToAlreadyPresentException extends RelationAlreadyPresentException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 1851536496095114678L;

	/**
	 * Instantiates a new checks if is related to already present exception.
	 *
	 * @param message the message
	 */
	public IsRelatedToAlreadyPresentException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new checks if is related to already present exception.
	 *
	 * @param cause the cause
	 */
	public IsRelatedToAlreadyPresentException(Throwable cause) {
		super(cause);
	}

	/**
	 * Instantiates a new checks if is related to already present exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public IsRelatedToAlreadyPresentException(String message, Throwable cause) {
		super(message, cause);
	}

}
