package org.gcube.informationsystem.resourceregistry.api.exceptions.contexts;

import java.io.Serial;


import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;

/**
 * The Class ContextNotFoundException.
 *
 * @author Luca Frosini (ISTI - CNR)
 */
public class ContextNotFoundException extends NotFoundException {

	/**
	 * Generated Serial Version UID
	 */
	@Serial
	private static final long serialVersionUID = 3034336911176161784L;

	/**
	 * Instantiates a new context not found exception.
	 *
	 * @param message the message
	 */
	public ContextNotFoundException(String message) {
		super(message);
	}

	/**
	 * Instantiates a new context not found exception.
	 *
	 * @param cause the cause
	 */
	public ContextNotFoundException(Throwable cause) {
		super(cause);
	}
	
	/**
	 * Instantiates a new context not found exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public ContextNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}

}
