/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.connector.resourceregistry;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.factories.AuthorizationProviderFactory;
import org.gcube.common.security.secrets.Secret;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.smartgears.configuration.AuthorizationProviderConfiguration;
import org.gcube.smartgears.connector.resourceregistry.resourcemanager.EServiceManager;
import org.gcube.smartgears.connector.resourceregistry.resourcemanager.HostingNodeManager;
import org.gcube.smartgears.connector.resourceregistry.resourcemanager.ResourceManager;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.publishing.Publisher;
import org.gcube.smartgears.publishing.SmartgearsProfilePublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SmartgearsProfilePublisher
public class FacetBasedPublisher
implements Publisher {
    private static Logger logger = LoggerFactory.getLogger(FacetBasedPublisher.class);
    private static Map<String, ResourceManager> managersCache = new ConcurrentHashMap<String, ResourceManager>();

    public static AuthorizationProvider getAuthorizationProvider(ApplicationContext applicationContext) {
        return FacetBasedPublisher.getAuthorizationProvider(applicationContext.container());
    }

    public static AuthorizationProvider getAuthorizationProvider(ContainerContext containerContext) {
        AuthorizationProviderConfiguration authorizationProviderConfiguration = containerContext.configuration().authorizationConfiguration();
        AuthorizationProviderFactory authorizationProviderFactory = authorizationProviderConfiguration.getAuthProviderFactory();
        AuthorizationProvider authorizationProvider = authorizationProviderFactory.connect(authorizationProviderConfiguration.getCredentials());
        return authorizationProvider;
    }

    public boolean create(ContainerContext containerContext, Set<String> contexts) {
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        TreeSet<String> contextToIterate = new TreeSet<String>(contexts);
        String context = (String)contextToIterate.first();
        String containerID = containerContext.id();
        try {
            AuthorizedTasks.executeSafely(() -> managersCache.computeIfAbsent(containerID, id -> {
                HostingNodeManager hostingNodeManager = new HostingNodeManager(containerContext);
                for (String c : contextToIterate) {
                    if (context.equals(c)) {
                        try {
                            hostingNodeManager.createHostingNode();
                            continue;
                        }
                        catch (ResourceRegistryException e) {
                            logger.error("Error while creating {} id={} in context {}", new Object[]{"HostingNode", containerID, context, e});
                            return hostingNodeManager;
                        }
                    }
                    try {
                        hostingNodeManager.addToContext(c);
                    }
                    catch (ResourceRegistryException e) {
                        logger.error("Error while adding {} id={} to context '{}'", new Object[]{"HostingNode", containerID, c, e});
                    }
                }
                return hostingNodeManager;
            }), (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Error while intiliating {} id={}. Available contexts {}", new Object[]{"HostingNode", containerID, contextToIterate, e});
        }
        return true;
    }

    public boolean create(ApplicationContext applicationContext, Set<String> contexts) {
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        TreeSet<String> contextToIterate = new TreeSet<String>(contexts);
        String context = (String)contextToIterate.first();
        String applicationID = applicationContext.id();
        try {
            AuthorizedTasks.executeSafely(() -> managersCache.computeIfAbsent(applicationID, id -> {
                EServiceManager eServiceManager = new EServiceManager(applicationContext);
                for (String c : contextToIterate) {
                    if (context.equals(c)) {
                        try {
                            eServiceManager.createEService();
                            continue;
                        }
                        catch (ResourceRegistryException e) {
                            logger.error("Error while creating {} name={} id={} in context {}", new Object[]{"EService", applicationContext.name(), applicationID, context, e});
                            return eServiceManager;
                        }
                    }
                    try {
                        eServiceManager.addToContext(c);
                    }
                    catch (Throwable e) {
                        logger.error("Error while adding {} name={} id={} to context {}", new Object[]{"EService", applicationContext.name(), applicationID, c, e});
                    }
                }
                return eServiceManager;
            }), (Secret)authorizationProvider.getSecretForContext(context));
        }
        catch (Throwable e) {
            logger.error("Error while initializing {} name={} id={}. Available contexts {}", new Object[]{"EService", applicationContext.name(), applicationID, contextToIterate, e});
        }
        return true;
    }

    public boolean remove(ContainerContext containerContext, Set<String> contexts) {
        HostingNodeManager hostingNodeManager = (HostingNodeManager)managersCache.get(containerContext.id());
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        for (String c : contexts) {
            AuthorizedTasks.executeSafely(() -> {
                try {
                    hostingNodeManager.removeFromCurrentContext();
                }
                catch (Throwable e) {
                    logger.error("Unable to remove {} id={} from context {}", new Object[]{"HostingNode", containerContext.id(), c, e});
                }
            }, (Secret)authorizationProvider.getSecretForContext(c));
        }
        return true;
    }

    public boolean remove(ApplicationContext applicationContext, Set<String> contexts) {
        EServiceManager eServiceManager = (EServiceManager)managersCache.get(applicationContext.id());
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        for (String c : contexts) {
            AuthorizedTasks.executeSafely(() -> {
                try {
                    eServiceManager.removeFromCurrentContext();
                }
                catch (Exception e) {
                    logger.error("Unable to remove {} name={} id={} from context {}", new Object[]{"EService", applicationContext.name(), applicationContext.id(), c, e});
                }
            }, (Secret)authorizationProvider.getSecretForContext(c));
        }
        return true;
    }

    public boolean update(ContainerContext containerContext) {
        HostingNodeManager hostingNodeManager = (HostingNodeManager)managersCache.get(containerContext.id());
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(containerContext);
        TreeSet contextToIterate = new TreeSet(authorizationProvider.getContexts());
        String context = (String)contextToIterate.first();
        AuthorizedTasks.executeSafely(() -> {
            try {
                hostingNodeManager.updateFacets();
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to update {} id={}", new Object[]{"HostingNode", containerContext.id(), e});
            }
        }, (Secret)authorizationProvider.getSecretForContext(context));
        return true;
    }

    public boolean update(ApplicationContext applicationContext) {
        EServiceManager eServiceManager = (EServiceManager)managersCache.get(applicationContext.id());
        AuthorizationProvider authorizationProvider = FacetBasedPublisher.getAuthorizationProvider(applicationContext);
        TreeSet contextToIterate = new TreeSet(authorizationProvider.getContexts());
        String context = (String)contextToIterate.first();
        AuthorizedTasks.executeSafely(() -> {
            try {
                eServiceManager.updateFacets();
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to update {} name={} id={}", new Object[]{"EService", applicationContext.name(), applicationContext.id(), e});
            }
        }, (Secret)authorizationProvider.getSecretForContext(context));
        return true;
    }
}

