/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.gcube.io.jsonwebtoken.Header;
import org.gcube.io.jsonwebtoken.JweHeader;
import org.gcube.io.jsonwebtoken.UnsupportedJwtException;
import org.gcube.io.jsonwebtoken.impl.DefaultJweHeader;
import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.RequiredParameterReader;
import org.gcube.io.jsonwebtoken.impl.security.AesWrapKeyAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.CryptoAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DefaultDecryptionKeyRequest;
import org.gcube.io.jsonwebtoken.impl.security.DefaultKeyRequest;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.DecryptionKeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyAlgorithm;
import org.gcube.io.jsonwebtoken.security.KeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyResult;
import org.gcube.io.jsonwebtoken.security.Password;
import org.gcube.io.jsonwebtoken.security.Request;
import org.gcube.io.jsonwebtoken.security.SecurityException;

public class Pbes2HsAkwAlgorithm
extends CryptoAlgorithm
implements KeyAlgorithm<Password, Password> {
    private static final int DEFAULT_SHA256_ITERATIONS = 310000;
    private static final int DEFAULT_SHA384_ITERATIONS = 210000;
    private static final int DEFAULT_SHA512_ITERATIONS = 120000;
    private static final int MIN_RECOMMENDED_ITERATIONS = 1000;
    private static final String MIN_ITERATIONS_MSG_PREFIX = "[JWA RFC 7518, Section 4.8.1.2](https://www.rfc-editor.org/rfc/rfc7518.html#section-4.8.1.2) recommends password-based-encryption iterations be greater than or equal to 1000. Provided: ";
    private static final double MAX_ITERATIONS_FACTOR = 2.5;
    private final int HASH_BYTE_LENGTH;
    private final int DERIVED_KEY_BIT_LENGTH;
    private final byte[] SALT_PREFIX;
    private final int DEFAULT_ITERATIONS;
    private final int MAX_ITERATIONS;
    private final KeyAlgorithm<SecretKey, SecretKey> wrapAlg;

    private static byte[] toRfcSaltPrefix(byte[] bytes) {
        byte[] output = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, output, 0, bytes.length);
        return output;
    }

    private static int hashBitLength(int keyBitLength) {
        return keyBitLength * 2;
    }

    private static String idFor(int hashBitLength, KeyAlgorithm<SecretKey, SecretKey> wrapAlg) {
        Assert.notNull(wrapAlg, (String)"wrapAlg argument cannot be null.");
        return "PBES2-HS" + hashBitLength + "+" + wrapAlg.getId();
    }

    public static int assertIterations(int iterations) {
        if (iterations < 1000) {
            String msg = MIN_ITERATIONS_MSG_PREFIX + iterations;
            throw new IllegalArgumentException(msg);
        }
        return iterations;
    }

    public Pbes2HsAkwAlgorithm(int keyBitLength) {
        this(Pbes2HsAkwAlgorithm.hashBitLength(keyBitLength), (KeyAlgorithm<SecretKey, SecretKey>)new AesWrapKeyAlgorithm(keyBitLength));
    }

    protected Pbes2HsAkwAlgorithm(int hashBitLength, KeyAlgorithm<SecretKey, SecretKey> wrapAlg) {
        super(Pbes2HsAkwAlgorithm.idFor(hashBitLength, wrapAlg), "PBKDF2WithHmacSHA" + hashBitLength);
        this.wrapAlg = wrapAlg;
        this.HASH_BYTE_LENGTH = hashBitLength / 8;
        this.DEFAULT_ITERATIONS = hashBitLength >= 512 ? 120000 : (hashBitLength >= 384 ? 210000 : 310000);
        this.MAX_ITERATIONS = (int)((double)this.DEFAULT_ITERATIONS * 2.5);
        this.DERIVED_KEY_BIT_LENGTH = hashBitLength / 2;
        this.SALT_PREFIX = Pbes2HsAkwAlgorithm.toRfcSaltPrefix(this.getId().getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SecretKey deriveKey(SecretKeyFactory factory, char[] password, byte[] rfcSalt, int iterations) throws Exception {
        PBEKeySpec spec = new PBEKeySpec(password, rfcSalt, iterations, this.DERIVED_KEY_BIT_LENGTH);
        try {
            SecretKey derived = factory.generateSecret(spec);
            SecretKeySpec secretKeySpec = new SecretKeySpec(derived.getEncoded(), "AES");
            return secretKeySpec;
        }
        finally {
            spec.clearPassword();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKey deriveKey(KeyRequest<?> request, final char[] password, final byte[] salt, final int iterations) {
        try {
            Assert.notEmpty((char[])password, (String)"Key password character array cannot be null or empty.");
            SecretKey secretKey = this.jca((Request<?>)request).withSecretKeyFactory(new CheckedFunction<SecretKeyFactory, SecretKey>(){

                @Override
                public SecretKey apply(SecretKeyFactory factory) throws Exception {
                    return Pbes2HsAkwAlgorithm.this.deriveKey(factory, password, salt, iterations);
                }
            });
            return secretKey;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    protected byte[] generateInputSalt(KeyRequest<?> request) {
        byte[] inputSalt = new byte[this.HASH_BYTE_LENGTH];
        Pbes2HsAkwAlgorithm.ensureSecureRandom(request).nextBytes(inputSalt);
        return inputSalt;
    }

    protected byte[] toRfcSalt(byte[] inputSalt) {
        return Bytes.concat(this.SALT_PREFIX, inputSalt);
    }

    public KeyResult getEncryptionKey(KeyRequest<Password> request) throws SecurityException {
        Assert.notNull(request, (String)"request cannot be null.");
        Password key = (Password)Assert.notNull((Object)request.getPayload(), (String)"Encryption Password cannot be null.");
        JweHeader header = (JweHeader)Assert.notNull((Object)request.getHeader(), (String)"JweHeader cannot be null.");
        Integer p2c = header.getPbes2Count();
        if (p2c == null) {
            p2c = this.DEFAULT_ITERATIONS;
            header.put((Object)DefaultJweHeader.P2C.getId(), (Object)p2c);
        }
        int iterations = Pbes2HsAkwAlgorithm.assertIterations(p2c);
        byte[] inputSalt = this.generateInputSalt(request);
        byte[] rfcSalt = this.toRfcSalt(inputSalt);
        char[] password = key.toCharArray();
        SecretKey derivedKek = this.deriveKey(request, password, rfcSalt, iterations);
        DefaultKeyRequest<SecretKey> wrapReq = new DefaultKeyRequest<SecretKey>(derivedKek, request.getProvider(), request.getSecureRandom(), request.getHeader(), request.getEncryptionAlgorithm());
        KeyResult result = this.wrapAlg.getEncryptionKey(wrapReq);
        request.getHeader().put((Object)DefaultJweHeader.P2S.getId(), (Object)inputSalt);
        return result;
    }

    public SecretKey getDecryptionKey(DecryptionKeyRequest<Password> request) throws SecurityException {
        JweHeader header = (JweHeader)Assert.notNull((Object)request.getHeader(), (String)"Request JweHeader cannot be null.");
        Password key = (Password)Assert.notNull((Object)request.getKey(), (String)"Decryption Password cannot be null.");
        RequiredParameterReader reader = new RequiredParameterReader((Header)header);
        byte[] inputSalt = reader.get(DefaultJweHeader.P2S);
        Parameter<Integer> param = DefaultJweHeader.P2C;
        int iterations = reader.get(param);
        if (iterations > this.MAX_ITERATIONS) {
            String msg = "JWE Header " + param + " value " + iterations + " exceeds " + this.getId() + " maximum " + "allowed value " + this.MAX_ITERATIONS + ". The larger value is rejected to help mitigate " + "potential Denial of Service attacks.";
            throw new UnsupportedJwtException(msg);
        }
        byte[] rfcSalt = Bytes.concat(this.SALT_PREFIX, inputSalt);
        char[] password = key.toCharArray();
        SecretKey derivedKek = this.deriveKey((KeyRequest<?>)request, password, rfcSalt, iterations);
        DefaultDecryptionKeyRequest<SecretKey> unwrapReq = new DefaultDecryptionKeyRequest<SecretKey>((byte[])request.getPayload(), request.getProvider(), request.getSecureRandom(), header, request.getEncryptionAlgorithm(), derivedKek);
        return this.wrapAlg.getDecryptionKey(unwrapReq);
    }
}

