/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameters;
import org.gcube.io.jsonwebtoken.impl.security.AbstractJwk;
import org.gcube.io.jsonwebtoken.impl.security.JwkContext;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.security.Jwk;
import org.gcube.io.jsonwebtoken.security.SecretJwk;

class DefaultSecretJwk
extends AbstractJwk<SecretKey>
implements SecretJwk {
    static final String TYPE_VALUE = "oct";
    static final Parameter<byte[]> K = (Parameter)Parameters.bytes("k", "Key Value").setSecret(true).build();
    static final Set<Parameter<?>> PARAMS = Collections.concat(AbstractJwk.PARAMS, (Object[])new Parameter[]{K});
    static final List<Parameter<?>> THUMBPRINT_PARAMS = Collections.of((Object[])new Parameter[]{K, KTY});

    DefaultSecretJwk(JwkContext<SecretKey> ctx) {
        super(ctx, THUMBPRINT_PARAMS);
    }

    @Override
    protected boolean equals(Jwk<?> jwk) {
        return jwk instanceof SecretJwk && Parameters.equals(this, jwk, K);
    }
}

