/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.gcube.common.security.credentials.Credentials;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.factories.AuthorizationProviderFactory;
import org.gcube.documentstore.security.provider.DefaultAuthorizationProviderFactory;
import org.ini4j.Ini;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LibraryConfigurationBinder {
    private static final Logger logger = LoggerFactory.getLogger(LibraryConfigurationBinder.class);
    public static final String DOCUMENT_STORE_LIB_CONFIGURATION_FILE = "dsl.ini";
    public static final String CONFIGURATION_SECTION_KEY = "configuration";
    public static final String CONFIGURATION_LIFETIME = "configurationExpiringTime";
    public static final String AUTHORIZATION_SECTION_KEY = "authorization";
    public static final String FACTORY_KEY = "factory";
    public static final String FACTORY_KEY_PREFIX = "factory.";
    public static final String CREDENTIALS_KEY = "credentials";
    public static final String CREDENTIALS_KEY_PREFIX = "credentials.";
    public static final String CREDENTIALS_CLASS_KEY = "credentials.class";
    protected static LibraryConfigurationBinder libraryConfigurationBinder;
    protected static long DEFAULT_LIFETIME;
    protected Calendar creationTime = Calendar.getInstance();
    protected long configurationLifetime = DEFAULT_LIFETIME;
    protected AuthorizationProvider authorizationProvider;

    private LibraryConfigurationBinder() {
    }

    public static LibraryConfigurationBinder getInstance() {
        Calendar now = Calendar.getInstance();
        Calendar expiringTime = Calendar.getInstance();
        if (libraryConfigurationBinder != null) {
            expiringTime.setTimeInMillis(LibraryConfigurationBinder.libraryConfigurationBinder.creationTime.getTimeInMillis());
            expiringTime.add(12, (int)LibraryConfigurationBinder.libraryConfigurationBinder.configurationLifetime);
        }
        if (libraryConfigurationBinder == null || now.after(expiringTime)) {
            libraryConfigurationBinder = new LibraryConfigurationBinder();
        }
        return libraryConfigurationBinder;
    }

    public AuthorizationProvider getAuthorizationProvider() throws Exception {
        String ghn_home = System.getenv("GHN_HOME");
        File configFile = new File(ghn_home, DOCUMENT_STORE_LIB_CONFIGURATION_FILE);
        String location = configFile.getAbsolutePath();
        logger.info("Going to read {} at {}", (Object)DOCUMENT_STORE_LIB_CONFIGURATION_FILE, (Object)location);
        FileInputStream inputStream = new FileInputStream(configFile);
        Ini ini = new Ini((InputStream)inputStream);
        Profile.Section configurationSection = (Profile.Section)ini.get((Object)CONFIGURATION_SECTION_KEY);
        if (configurationSection != null) {
            String expiringTimeString = (String)configurationSection.get((Object)CONFIGURATION_LIFETIME);
            if (expiringTimeString != null) {
                try {
                    this.configurationLifetime = Long.parseLong(expiringTimeString);
                }
                catch (NumberFormatException e) {
                    logger.warn("ini file error ({}): invalid {} value in {} section. Default value (i.e. {} minutes) wil be used", new Object[]{location, CONFIGURATION_LIFETIME, CONFIGURATION_SECTION_KEY, DEFAULT_LIFETIME, e});
                }
            }
        } else {
            logger.info("ini file error ({}): No {} value in {} section. Default value (i.e. {} minutes) wil be used", new Object[]{location, CONFIGURATION_LIFETIME, CONFIGURATION_SECTION_KEY, DEFAULT_LIFETIME});
        }
        Profile.Section authorizationSection = (Profile.Section)ini.get((Object)AUTHORIZATION_SECTION_KEY);
        if (authorizationSection != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ini file (");
            buffer.append(location);
            buffer.append(") error: ");
            String provider = (String)authorizationSection.get((Object)FACTORY_KEY);
            DefaultAuthorizationProviderFactory authProviderFactory = null;
            if (provider != null) {
                try {
                    Object authProviderImpl = Class.forName(provider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    authProviderFactory = (AuthorizationProviderFactory)AuthorizationProviderFactory.class.cast(authProviderImpl);
                    authorizationSection.to((Object)authProviderFactory, FACTORY_KEY_PREFIX);
                }
                catch (Exception e) {
                    StringBuffer error = new StringBuffer(buffer);
                    error.append(" invalid ");
                    error.append(AuthorizationProviderFactory.class.getSimpleName());
                    error.append(" type in ");
                    error.append(AUTHORIZATION_SECTION_KEY);
                    error.append(" section ");
                    error.append(FACTORY_KEY);
                    error.append(" key.");
                    logger.error(error.toString(), (Throwable)e);
                    throw new Exception(error.toString(), e);
                }
            } else {
                authProviderFactory = new DefaultAuthorizationProviderFactory();
            }
            String credentialClass = (String)authorizationSection.get((Object)CREDENTIALS_CLASS_KEY);
            if (credentialClass == null) {
                StringBuffer error = new StringBuffer(buffer);
                error.append(" not found in ");
                error.append(AUTHORIZATION_SECTION_KEY);
                error.append(" section ");
                error.append(CREDENTIALS_CLASS_KEY);
                error.append(" key.");
                logger.error(error.toString());
                throw new Exception(error.toString());
            }
            try {
                Object credentialsImpl = Class.forName(credentialClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Credentials credentials = (Credentials)Credentials.class.cast(credentialsImpl);
                authorizationSection.to((Object)credentials, CREDENTIALS_KEY_PREFIX);
                this.authorizationProvider = authProviderFactory.connect(credentials);
            }
            catch (Exception e) {
                StringBuffer error = new StringBuffer(buffer);
                error.append(" invalid ");
                error.append(Credentials.class.getSimpleName());
                error.append(" type in ");
                error.append(AUTHORIZATION_SECTION_KEY);
                error.append(" section ");
                error.append(CREDENTIALS_CLASS_KEY);
                error.append(" key.");
                logger.error(error.toString(), (Throwable)e);
                throw new Exception(error.toString(), e);
            }
        }
        return this.authorizationProvider;
    }

    static {
        DEFAULT_LIFETIME = TimeUnit.MINUTES.toMinutes(5L);
    }
}

