package org.gcube.common.security.factories;

import org.gcube.common.security.credentials.Credentials;



/**
 * A factory interface for creating instances of {@link AuthorizationProvider}.
 * This design pattern allows for abstracting the creation process of a provider,
 * making the code more flexible and easier to test.
 *
 * @param <T> The specific type of {@link AuthorizationProvider} that this
 * factory can create. It must be a subtype of {@code AuthorizationProvider}.
 */
public interface AuthorizationProviderFactory<T extends AuthorizationProvider> {

	/**
	 * Creates and initializes an instance of {@link AuthorizationProvider} using
	 * the provided credentials.
	 *
	 * This method "connects" or configures the provider with the necessary
	 * credentials to retrieve secrets and authorization data.
	 *
	 * @param credentials The credentials required to connect to or configure
	 * the provider.
	 * @return A fully initialized instance of {@link AuthorizationProvider},
	 * of the type specified by the generic parameter {@code T}.
	 * @throws RuntimeException if the connection or initialization fails
	 * (e.g., due to invalid credentials).
	 */
	T connect(Credentials credentials);
	
}