/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sr.transforms;

import com.hp.hpl.jena.rdf.model.Model;
import javax.xml.transform.Source;
import org.virtual.sr.transforms.Xml2Rdf;
import org.virtual.sr.transforms.XmlTransform;
import org.virtualrepository.Asset;
import org.virtualrepository.spi.Transform;

public class Asset2Rdf<A extends Asset, T>
implements Transform<A, T, Model> {
    private final XmlTransform<T> transform;

    public Asset2Rdf(XmlTransform<T> transform) {
        this.transform = transform;
    }

    public Model apply(A asset, T content) throws Exception {
        Xml2Rdf converter = new Xml2Rdf();
        Source source = null;
        try {
            source = this.transform.toXml(content, (Asset)asset);
        }
        catch (Exception e) {
            throw new Exception("cannot transform " + asset.type() + " to XML (see cause)", e);
        }
        return converter.triplify(source);
    }

    public Class<T> inputAPI() {
        return this.transform.api();
    }

    public Class<Model> outputAPI() {
        return Model.class;
    }
}

