/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.sdmxregistry;

import java.util.Iterator;
import org.gcube.datapublishing.sdmx.api.registry.SDMXRegistryClient;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.virtual.sdmxregistry.ClientFactory;
import org.virtualrepository.impl.Type;
import org.virtualrepository.sdmx.SdmxCodelist;
import org.virtualrepository.spi.Importer;

public class RegistryImporter
implements Importer<SdmxCodelist, CodelistBean> {
    private final ClientFactory factory;

    public RegistryImporter(ClientFactory factory) {
        this.factory = factory;
    }

    public Type<SdmxCodelist> type() {
        return SdmxCodelist.type;
    }

    public Class<CodelistBean> api() {
        return CodelistBean.class;
    }

    public CodelistBean retrieve(SdmxCodelist asset) throws Exception {
        SDMXRegistryClient client = this.factory.client();
        SdmxBeans beans = client.getCodelist("all", asset.remoteId(), asset.version(), SDMXRegistryClient.Detail.referencestubs, SDMXRegistryClient.References.none);
        Iterator it = beans.getCodelists().iterator();
        if (it.hasNext()) {
            return (CodelistBean)it.next();
        }
        throw new IllegalStateException("unknown codelist " + asset.remoteId() + "(" + asset.version() + ")");
    }
}

