/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository;

import javax.xml.namespace.QName;
import org.virtualrepository.AssetType;

public class Utils {
    public static void notNull(Object o) throws IllegalArgumentException {
        Utils.notNull("argument", o);
    }

    public static void notNull(AssetType type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("asset type is null");
        }
    }

    public static void notNull(AssetType ... types) throws IllegalArgumentException {
        Utils.notNull("asset types", (Object)types);
        for (AssetType type : types) {
            Utils.notNull(type);
        }
    }

    public static void notNull(String name, Object o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    public static void notEmpty(String name, String o) throws IllegalArgumentException {
        if (o.isEmpty()) {
            throw new IllegalArgumentException(name + " is empty");
        }
    }

    public static void valid(String name, String o) throws IllegalArgumentException {
        Utils.notNull(name, o);
        Utils.notEmpty(name, o);
    }

    public static void valid(QName name) throws IllegalArgumentException {
        Utils.notNull("name", name);
        Utils.valid("name", name.getLocalPart());
    }

    public static void valid(String text, QName name) throws IllegalArgumentException {
        Utils.notNull(text, name);
        Utils.valid(text, name.getLocalPart());
    }
}

