/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.virtualrepository.AssetType;
import org.virtualrepository.Property;
import org.virtualrepository.Utils;
import org.virtualrepository.impl.PropertyHolder;
import org.virtualrepository.spi.Accessor;
import org.virtualrepository.spi.ServiceProxy;

public final class RepositoryService
extends PropertyHolder {
    private final QName name;
    private final ServiceProxy proxy;

    public RepositoryService(QName name, ServiceProxy proxy, Property ... properties) {
        this.name = name;
        this.proxy = proxy;
        this.properties().add(properties);
        Utils.valid("service name", name);
        Utils.notNull("service proxy", proxy);
    }

    public QName name() {
        return this.name;
    }

    public ServiceProxy proxy() {
        return this.proxy;
    }

    public boolean publishes(AssetType ... types) {
        return this.supports(this.proxy.publishers(), types);
    }

    public Collection<AssetType> publishedTypes() {
        return this.supported(this.proxy.publishers());
    }

    public boolean returns(AssetType ... types) {
        return this.supports(this.proxy.importers(), types);
    }

    public Collection<AssetType> returnedTypes() {
        return this.supported(this.proxy.importers());
    }

    private boolean supports(List<? extends Accessor<?, ?>> accessors, AssetType ... types) {
        Utils.notNull("asset types", (Object)types);
        for (AssetType supported : this.supported(accessors)) {
            for (AssetType type : types) {
                if (!supported.equals(type)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<AssetType> supported(List<? extends Accessor<?, ?>> accessors) {
        HashSet<AssetType> types = new HashSet<AssetType>();
        for (Accessor<?, ?> accessor : accessors) {
            types.add(accessor.type());
        }
        return types;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.proxy == null ? 0 : this.proxy.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryService other = (RepositoryService)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.proxy == null ? other.proxy != null : !this.proxy.equals(other.proxy));
    }

    public String toString() {
        return "[name=" + this.name + ", proxy=" + this.proxy + "]";
    }
}

