/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.tabular;

import javax.xml.namespace.QName;
import org.virtualrepository.Utils;
import org.virtualrepository.impl.PropertyHolder;

public class Column
extends PropertyHolder {
    private final QName name;
    private QName kind;
    private Class<?> type;

    public static QName q(String string) {
        Utils.notNull(string);
        return new QName(string);
    }

    public Column(QName name) {
        this(name, String.class);
    }

    public Column(String name) {
        this(new QName(name), String.class);
    }

    public Column(QName name, Class<?> type) {
        Utils.valid(name);
        this.name = name;
        Utils.notNull("type", type);
        this.type = type;
    }

    public Column(QName name, QName kind) {
        this(name);
        this.setKind(kind);
    }

    public Column(QName name, QName kind, Class<?> type) {
        this(name, kind);
        this.setType(type);
    }

    public QName name() {
        return this.name;
    }

    public QName getKind() {
        return this.kind;
    }

    public void setKind(QName kind) {
        this.kind = kind;
    }

    public Class<?> type() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        if (this.kind == null ? other.kind != null : !this.kind.equals(other.kind)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "Column [name=" + this.name + ", kind=" + this.kind + ", type=" + this.type + "]";
    }
}

