/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.spi;

import org.virtualrepository.Asset;
import org.virtualrepository.Utils;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.Transform;

public class PublishAdapter<T extends Asset, A1, A2>
implements Publisher<T, A2> {
    private final Publisher<T, A1> publisher;
    private final Transform<T, A2, A1> transform;

    public static <T extends Asset, A1, A2> Publisher<T, A2> adapt(Publisher<T, A1> publisher, Transform<T, A2, A1> transform) {
        Utils.notNull("publisher", publisher);
        Utils.notNull("transform", transform);
        return new PublishAdapter<T, A1, A2>(publisher, transform);
    }

    private PublishAdapter(Publisher<T, A1> publisher, Transform<T, A2, A1> transform) {
        this.publisher = publisher;
        this.transform = transform;
    }

    @Override
    public Type<T> type() {
        return this.publisher.type();
    }

    @Override
    public Class<A2> api() {
        return this.transform.inputAPI();
    }

    @Override
    public void publish(T asset, A2 content) throws Exception {
        A1 transformed = this.transform.apply(asset, content);
        this.publisher.publish(asset, transformed);
    }
}

