/*
 * Decompiled with CFR 0.152.
 */
package org.virtualrepository.impl;

import org.virtualrepository.AssetType;
import org.virtualrepository.Property;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.Utils;
import org.virtualrepository.impl.PropertyHolder;
import org.virtualrepository.spi.MutableAsset;

public abstract class AbstractAsset
extends PropertyHolder
implements MutableAsset {
    private AssetType _type;
    private String id;
    private String name;
    private RepositoryService service;

    protected AbstractAsset(AssetType type, String id, String name, Property ... properties) {
        Utils.notNull("_type", (Object)type);
        this._type = type;
        Utils.notNull("asset identifier", id);
        this.id = id;
        Utils.notNull("asset name", id);
        this.name = name;
        this.properties().add(properties);
    }

    protected AbstractAsset(AssetType type, String id, String name, RepositoryService service, Property ... properties) {
        this(type, id, name, properties);
        Utils.notNull("target service", service);
        this.setService(service);
    }

    protected AbstractAsset(AssetType type, String name, RepositoryService service, Property ... properties) {
        this(type, "unassigned", name, service, properties);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public AssetType type() {
        return this._type;
    }

    @Override
    public RepositoryService service() {
        return this.service;
    }

    @Override
    public void setService(RepositoryService service) {
        Utils.notNull("asset service", this.id);
        this.service = service;
        this.service = service;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return this.type().name() + " [" + this.id() + "," + this.name() + (this.properties().isEmpty() ? "" : ", " + this.properties()) + "," + this.service() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAsset other = (AbstractAsset)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
            return false;
        }
        return !(this._type == null ? other._type != null : !this._type.equals(other._type));
    }
}

