/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.ows;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import lombok.NonNull;
import org.geotoolkit.feature.xml.jaxp.JAXPStreamFeatureReader;
import org.virtual.ows.WfsClient;
import org.virtualrepository.impl.Type;
import org.virtualrepository.ows.Features;
import org.virtualrepository.ows.WfsFeatureType;
import org.virtualrepository.spi.Importer;

public class WfsReader
implements Importer<WfsFeatureType, Features> {
    @NonNull
    final WfsClient client;

    public Type<? extends WfsFeatureType> type() {
        return WfsFeatureType.type;
    }

    public Class<Features> api() {
        return Features.class;
    }

    public Features retrieve(@NonNull WfsFeatureType asset) throws Exception {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        String name = asset.name();
        JAXPStreamFeatureReader reader = new JAXPStreamFeatureReader(Arrays.asList(this.client.typeFor(name)));
        InputStream stream = (InputStream)this.client.featuresFor(asset.name()).get(InputStream.class);
        Collection coll = (Collection)reader.read((Object)stream);
        return new Features(coll);
    }

    @ConstructorProperties(value={"client"})
    public WfsReader(@NonNull WfsClient client) {
        if (client == null) {
            throw new IllegalArgumentException("client is null");
        }
        this.client = client;
    }
}

