/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.workspace.types;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gcube.common.homelibrary.home.workspace.Properties;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.workspace.types.AbstractWorkspaceType;
import org.virtual.workspace.utils.Tags;
import org.virtualrepository.Asset;
import org.virtualrepository.Property;
import org.virtualrepository.csv.CsvCodelist;
import org.virtualrepository.csv.CsvStream2Table;
import org.virtualrepository.csv.Table2CsvStream;
import org.virtualrepository.spi.Transform;
import org.virtualrepository.tabular.Table;

public class WsCsvCodelist
extends AbstractWorkspaceType<CsvCodelist, Table> {
    private static final Logger log = LoggerFactory.getLogger(WsCsvCodelist.class);
    private final Transform<CsvCodelist, InputStream, Table> importTransform = new CsvStream2Table();
    private final Transform<CsvCodelist, Table, InputStream> publishTransform = new Table2CsvStream();

    @Inject
    public WsCsvCodelist() {
        super(CsvCodelist.type, "text/plain");
    }

    @Override
    public CsvCodelist getAsset(WorkspaceItem item) throws Exception {
        CsvCodelist list = new CsvCodelist(item.getId(), item.getName(), 0, new Property[0]);
        try {
            String encoding;
            String quote;
            String delimiter;
            Map props = item.getProperties().getProperties();
            if (props.containsKey(Tags.HEADER.name())) {
                list.hasHeader(true);
            }
            if (props.containsKey(Tags.DELIMITER.name()) && !(delimiter = (String)props.get(Tags.DELIMITER.name())).isEmpty()) {
                list.setDelimiter(delimiter.charAt(0));
            }
            if (props.containsKey(Tags.QUOTE.name()) && !(quote = (String)props.get(Tags.QUOTE.name())).isEmpty()) {
                list.setQuote(quote.charAt(0));
            }
            if (props.containsKey(Tags.ENCODING.name()) && Charset.isSupported(encoding = (String)props.get(Tags.ENCODING.name()))) {
                list.setEncoding(Charset.forName(encoding));
            }
        }
        catch (Exception e) {
            log.error("error trasforming item properties into asset properties", (Throwable)e);
        }
        return list;
    }

    @Override
    public void toItem(Asset asset, Properties props) throws Exception {
        CsvCodelist list = (CsvCodelist)asset;
        props.addProperty(Tags.HEADER.name(), String.valueOf(list.hasHeader()));
        props.addProperty(Tags.DELIMITER.name(), String.valueOf(list.delimiter()));
        props.addProperty(Tags.QUOTE.name(), String.valueOf(list.quote()));
        props.addProperty(Tags.ENCODING.name(), list.encoding().displayName());
    }

    @Override
    public Set<String> tags() {
        return new HashSet<String>(Arrays.asList(Tags.CODELIST.name(), Tags.CSV.name()));
    }

    @Override
    public Transform<CsvCodelist, InputStream, Table> fromStream() {
        return this.importTransform;
    }

    @Override
    public Transform<CsvCodelist, Table, InputStream> toStream() {
        return this.publishTransform;
    }
}

