/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.local;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import lombok.NonNull;
import org.virtual.files.common.Utils;
import org.virtual.files.config.ServiceConfiguration;

public class LocalConfiguration
extends ServiceConfiguration {
    public static final String tag = "local";
    @JsonProperty
    String type = "local";
    @JsonProperty
    @NonNull
    private String location;

    @Override
    public void validate() {
        File folder = new File(this.location);
        Utils.validDirectory(folder);
        File assetfile = new File(folder, "vindex.json");
        Utils.valid(assetfile);
    }

    @Override
    public String type() {
        return this.type;
    }

    @NonNull
    public String location() {
        return this.location;
    }

    public LocalConfiguration location(@NonNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        this.location = location;
        return this;
    }

    @Override
    public String toString() {
        return "LocalConfiguration(type=" + this.type() + ", location=" + this.location() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalConfiguration)) {
            return false;
        }
        LocalConfiguration other = (LocalConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$type = this.type();
        String other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$location = this.location();
        String other$location = other.location();
        return !(this$location == null ? other$location != null : !this$location.equals(other$location));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LocalConfiguration;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $type = this.type();
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        String $location = this.location();
        result = result * 59 + ($location == null ? 0 : $location.hashCode());
        return result;
    }

    private LocalConfiguration(@NonNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        this.location = location;
    }

    public static LocalConfiguration local(@NonNull String location) {
        return new LocalConfiguration(location);
    }

    public LocalConfiguration() {
    }

    private LocalConfiguration type(String type) {
        this.type = type;
        return this;
    }
}

