/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import lombok.NonNull;
import org.virtual.files.Provider;
import org.virtual.files.index.AssetInfo;
import org.virtualrepository.Asset;
import org.virtualrepository.Properties;
import org.virtualrepository.Property;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.Importer;

public class FileImporter
implements Importer<Asset, InputStream> {
    @NonNull
    Provider provider;

    public InputStream retrieve(Asset asset) throws Exception {
        AssetInfo entry = this.entryIn(asset);
        return this.provider.load(entry);
    }

    public Type<? extends Asset> type() {
        return Type.any;
    }

    public Class<InputStream> api() {
        return InputStream.class;
    }

    AssetInfo entryIn(Asset asset) {
        Properties props = asset.properties();
        if (!props.contains("vfile_info")) {
            throw new IllegalArgumentException("unresolvable asset: no property vfile_info");
        }
        Property property = props.lookup("vfile_info");
        if (!property.is(AssetInfo.class)) {
            throw new IllegalArgumentException("invalid asset: unexpdcted value for property vfile_info");
        }
        return (AssetInfo)property.value(AssetInfo.class);
    }

    @ConstructorProperties(value={"provider"})
    public FileImporter(@NonNull Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null");
        }
        this.provider = provider;
    }
}

