/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.virtual.files.FileBrowser;
import org.virtual.files.FileImporter;
import org.virtual.files.FilePublisher;
import org.virtual.files.Provider;
import org.virtual.files.transforms.ToTable;
import org.virtualrepository.Asset;
import org.virtualrepository.spi.ImportAdapter;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.ServiceProxy;
import org.virtualrepository.spi.Transform;

public class FileProxy
implements ServiceProxy {
    @NonNull
    FileBrowser browser;
    List<Importer<?, ?>> importers = new ArrayList();
    List<Publisher<?, ?>> publishers = new ArrayList();

    public FileProxy(Provider provider) {
        this.browser = new FileBrowser(provider);
        FileImporter base = new FileImporter(provider);
        this.importers.addAll(Arrays.asList(base, this.adapt(base, new ToTable()), this.adapt(base, new ToTable())));
        FilePublisher basepub = new FilePublisher(provider);
        this.publishers.addAll(Arrays.asList(basepub));
    }

    <A extends Asset, O> Importer<A, O> adapt(FileImporter base, Transform<A, InputStream, O> transform) {
        FileImporter safebase = base;
        return ImportAdapter.adapt((Importer)safebase, transform);
    }

    @NonNull
    public FileBrowser browser() {
        return this.browser;
    }

    public List<Importer<?, ?>> importers() {
        return this.importers;
    }

    public List<Publisher<?, ?>> publishers() {
        return this.publishers;
    }
}

