/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.data.fao;

import dagger.ObjectGraph;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.data.fao.DatabaseProxy;
import org.virtual.data.fao.Databases;
import org.virtual.data.fao.io.Request;
import org.virtual.data.fao.resources.Database;
import org.virtual.data.fao.utils.Dependencies;
import org.virtualrepository.RepositoryService;
import org.virtualrepository.spi.Lifecycle;
import org.virtualrepository.spi.Plugin;
import org.virtualrepository.spi.ServiceProxy;

public class RepositoryPlugin
implements Plugin,
Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(RepositoryPlugin.class);
    @Inject
    Databases finder;
    @Inject
    Provider<Request> requests;

    public void init() throws Exception {
        ObjectGraph.create((Object[])new Object[]{new Dependencies()}).inject((Object)this);
    }

    public Collection<RepositoryService> services() {
        log.info("initialising plugin...");
        ArrayList<RepositoryService> services = new ArrayList<RepositoryService>();
        for (Database db : this.finder.find()) {
            services.add(new RepositoryService(new QName(db.name()), (ServiceProxy)new DatabaseProxy(db, this.requests), db.properties()));
        }
        return services;
    }
}

