/*
 * Decompiled with CFR 0.152.
 */
package api.tabular;

import api.tabular.Property;
import api.tabular.utils.Streamable;
import api.tabular.utils.TableUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Properties
implements Streamable<Property> {
    private final Map<String, Property> properties = Collections.synchronizedMap(new HashMap());

    @Override
    public Iterator<Property> iterator() {
        return this.properties.values().iterator();
    }

    public static Properties props(Property ... properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        return Properties.props().add(properties);
    }

    public Properties add(String ... props) {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        return this.add(Arrays.asList(props).stream().map(Property::prop).collect(Collectors.toList()));
    }

    public Properties add(Property ... props) {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        return this.add(Arrays.asList(props));
    }

    public Properties add(@NonNull Iterable<Property> props) {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        TableUtils.streamof(props).forEach($ -> this.properties.put($.name(), (Property)$));
        return this;
    }

    public boolean has(@NonNull Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        return this.has((Iterable<Property>)props);
    }

    public boolean has(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("names is null");
        }
        return this.has((Collection<String>)Arrays.asList(names));
    }

    public boolean has(@NonNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("names is null");
        }
        return TableUtils.streamof(names).allMatch(this.properties::containsKey);
    }

    public boolean has(Property ... ps) {
        if (ps == null) {
            throw new IllegalArgumentException("ps is null");
        }
        return this.has((Iterable<Property>)Arrays.asList(ps));
    }

    public boolean has(@NonNull Iterable<Property> ps) {
        if (ps == null) {
            throw new IllegalArgumentException("ps is null");
        }
        return TableUtils.streamof(ps).allMatch(this.properties::containsValue);
    }

    public Properties remove(String ... names) {
        if (names == null) {
            throw new IllegalArgumentException("names is null");
        }
        return this.remove((Collection<String>)Arrays.asList(names));
    }

    public Properties remove(@NonNull Collection<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("names is null");
        }
        names.forEach(this.properties::remove);
        return this;
    }

    public Properties remove(@NonNull Iterable<Property> properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        return this.remove(TableUtils.streamof(properties).map(Property::name).collect(Collectors.toList()));
    }

    public Properties remove(@NonNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        return this.remove((Iterable<Property>)properties);
    }

    public Properties remove(Property ... properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is null");
        }
        return this.remove((Iterable<Property>)Arrays.asList(properties));
    }

    public Property prop(@NonNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        Property property = this.properties.get(name);
        if (property == null) {
            throw new IllegalStateException("unknown property " + name);
        }
        return property;
    }

    public Property propOr(@NonNull String name, @NonNull Object fallbackValue) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (fallbackValue == null) {
            throw new IllegalArgumentException("fallbackValue is null");
        }
        return this.has(name) ? this.prop(name) : Property.prop(name, fallbackValue);
    }

    public boolean empty() {
        return this.properties.isEmpty();
    }

    public int size() {
        return this.properties.size();
    }

    public String toString() {
        Function<Map.Entry, String> tostring = $ -> String.format("%s=%s", $.getKey(), ((Property)$.getValue()).value());
        return String.format("[%s]", this.properties.entrySet().stream().map(tostring).collect(Collectors.joining(",")));
    }

    private Properties() {
    }

    public static Properties props() {
        return new Properties();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Properties)) {
            return false;
        }
        Properties other = (Properties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Property> this$properties = this.properties;
        Map<String, Property> other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Properties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Property> $properties = this.properties;
        result = result * 59 + ($properties == null ? 0 : ((Object)$properties).hashCode());
        return result;
    }
}

