/*
 * Decompiled with CFR 0.152.
 */
package api.tabular;

import api.tabular.Column;
import api.tabular.Table;
import api.tabular.dsl.Dsl;
import api.tabular.impl.CsvTable;
import api.tabular.utils.TableUtils;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Csv {
    private boolean hasHeader = true;
    private char delimiter = (char)44;
    @NonNull
    private String encoding = Charset.defaultCharset().name();
    private char quote = (char)34;
    private int rows = Integer.MAX_VALUE;
    @NonNull
    private final List<Column> columns = new ArrayList<Column>();

    public Csv with(Column ... cols) {
        if (cols == null) {
            throw new IllegalArgumentException("cols is null");
        }
        this.columns.addAll(Arrays.asList(cols));
        return this;
    }

    public Csv with(@NonNull Iterable<Column> cols) {
        if (cols == null) {
            throw new IllegalArgumentException("cols is null");
        }
        TableUtils.streamof(cols).forEach(this.columns::add);
        return this;
    }

    public Csv with(String ... cols) {
        if (cols == null) {
            throw new IllegalArgumentException("cols is null");
        }
        return this.with((Collection<String>)Arrays.asList(cols));
    }

    public Csv with(@NonNull Collection<String> cols) {
        if (cols == null) {
            throw new IllegalArgumentException("cols is null");
        }
        return this.with(cols.stream().map(Column::new).collect(Collectors.toList()));
    }

    public Dsl.SinkClause serialise(Table table) {
        return stream -> {
            try {
                List<Column> columns;
                OutputStreamWriter writer = new OutputStreamWriter(stream, this.encoding);
                CSVWriter csvwriter = new CSVWriter((Writer)writer, this.delimiter, this.quote);
                List<Column> list = columns = this.columns().isEmpty() ? table.columns() : this.columns();
                if (this.hasHeader) {
                    List<String> colcoll = columns.stream().map(Column::name).collect(Collectors.toList());
                    csvwriter.writeNext(colcoll.toArray(new String[0]));
                }
                table.stream().map(r -> columns.stream().map(c -> r.get(c.name())).filter(c -> c != null && !c.isEmpty()).collect(Collectors.toList())).map(l -> l.toArray(new String[0])).forEachOrdered(arg_0 -> ((CSVWriter)csvwriter).writeNext(arg_0));
                csvwriter.flush();
                if (this.columns().isEmpty()) {
                    this.columns().addAll(columns);
                }
            }
            catch (Exception e) {
                throw (RuntimeException)e;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream convert(Table table) {
        ByteArrayInputStream byteArrayInputStream;
        block6: {
            ByteArrayOutputStream stream = new ByteArrayOutputStream(512);
            try {
                this.serialise(table).to(stream);
                byteArrayInputStream = new ByteArrayInputStream(stream.toByteArray());
                if (Collections.singletonList(stream).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        return byteArrayInputStream;
    }

    public Dsl.SourceClause parse() {
        return stream -> new CsvTable(this, stream);
    }

    public boolean hasHeader() {
        return this.hasHeader;
    }

    public char delimiter() {
        return this.delimiter;
    }

    @NonNull
    public String encoding() {
        return this.encoding;
    }

    public char quote() {
        return this.quote;
    }

    public int rows() {
        return this.rows;
    }

    @NonNull
    public List<Column> columns() {
        return this.columns;
    }

    public Csv hasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
        return this;
    }

    public Csv delimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public Csv encoding(@NonNull String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        this.encoding = encoding;
        return this;
    }

    public Csv quote(char quote) {
        this.quote = quote;
        return this;
    }

    public Csv rows(int rows) {
        this.rows = rows;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Csv)) {
            return false;
        }
        Csv other = (Csv)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.hasHeader() != other.hasHeader()) {
            return false;
        }
        if (this.delimiter() != other.delimiter()) {
            return false;
        }
        String this$encoding = this.encoding();
        String other$encoding = other.encoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        if (this.quote() != other.quote()) {
            return false;
        }
        if (this.rows() != other.rows()) {
            return false;
        }
        List<Column> this$columns = this.columns();
        List<Column> other$columns = other.columns();
        return !(this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Csv;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hasHeader() ? 79 : 97);
        result = result * 59 + this.delimiter();
        String $encoding = this.encoding();
        result = result * 59 + ($encoding == null ? 0 : $encoding.hashCode());
        result = result * 59 + this.quote();
        result = result * 59 + this.rows();
        List<Column> $columns = this.columns();
        result = result * 59 + ($columns == null ? 0 : ((Object)$columns).hashCode());
        return result;
    }

    public String toString() {
        return "Csv(" + this.hasHeader() + ", " + this.delimiter() + ", " + this.encoding() + ", " + this.quote() + ", " + this.rows() + ", " + this.columns() + ")";
    }

    private Csv() {
    }

    public static Csv csv() {
        return new Csv();
    }
}

