/*
 * Decompiled with CFR 0.152.
 */
package org.grade.client.upload.csv;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;
import lombok.NonNull;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.ContentDisposition;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.grade.client.upload.UploadType;

public class CsvParams
extends UploadType.Private {
    static final String cpart_name = "content";
    static final String ipart_name = "info";
    static final MediaType media;
    @JsonProperty
    private char delimiter = (char)44;
    @JsonProperty
    @NonNull
    private String encoding = Charset.defaultCharset().name();
    @JsonProperty
    private char quote = (char)34;

    public CsvParams() {
        super("csv");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entity<?> bodyWith(InputStream content) {
        Entity entity;
        block6: {
            ContentDisposition content_part = ContentDisposition.type((String)"form-data;name=\"content\"").build();
            ContentDisposition info_part = ContentDisposition.type((String)"form-data;name=\"info\"").build();
            BodyPart cpart = new BodyPart((Object)content, new MediaType("text", "csv")).contentDisposition(content_part);
            BodyPart ipart = new BodyPart((Object)this, MediaType.APPLICATION_JSON_TYPE).contentDisposition(info_part);
            MultiPart multipart = new MultiPart().bodyPart(cpart).bodyPart(ipart);
            try {
                entity = Entity.entity((Object)multipart, (Variant)this.compressed(media));
                if (Collections.singletonList(multipart).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(multipart).get(0) != null) {
                    multipart.close();
                }
                throw throwable;
            }
            multipart.close();
        }
        return entity;
    }

    public char delimiter() {
        return this.delimiter;
    }

    @NonNull
    public String encoding() {
        return this.encoding;
    }

    public char quote() {
        return this.quote;
    }

    public CsvParams delimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public CsvParams encoding(@NonNull String encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding is null");
        }
        this.encoding = encoding;
        return this;
    }

    public CsvParams quote(char quote) {
        this.quote = quote;
        return this;
    }

    @Override
    public String toString() {
        return "CsvParams(delimiter=" + this.delimiter() + ", encoding=" + this.encoding() + ", quote=" + this.quote() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CsvParams)) {
            return false;
        }
        CsvParams other = (CsvParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.delimiter() != other.delimiter()) {
            return false;
        }
        String this$encoding = this.encoding();
        String other$encoding = other.encoding();
        if (this$encoding == null ? other$encoding != null : !this$encoding.equals(other$encoding)) {
            return false;
        }
        return this.quote() == other.quote();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CsvParams;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        result = result * 59 + this.delimiter();
        String $encoding = this.encoding();
        result = result * 59 + ($encoding == null ? 0 : $encoding.hashCode());
        result = result * 59 + this.quote();
        return result;
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("boundary", UUID.randomUUID().toString());
        media = new MediaType("multipart", "form-data", params);
    }
}

